/*
*  RAL -- Rubrica Addressbook Library
*  file: init.h  
*
*  Copyright (C) 2006 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_LIB_INIT_H
#define _R_LIB_INIT_H

#include <glib.h>
#include <glib-object.h>

#include "card.h"
// #include "trash.h"
#include "error.h"


gboolean r_lib_init                (void); 
void     r_lib_admit               (gpointer abook);

gboolean r_lib_is_running          (void);

gpointer r_lib_get_manager         (void);
gpointer r_lib_get_group_box       (void);
gpointer r_lib_get_timeout         (void);
GList*   r_lib_get_addressbooks    (void);
gpointer r_lib_get_nth_addressbook (gint n);
gchar*   r_lib_get_release         (void);
gchar*   r_lib_get_code_name       (void);
gchar*   r_lib_get_info            (void);
gchar*   r_lib_get_ral_info        (void);

#endif
