/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import org.apache.lucene.codecs.memory.LegacySortedNumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;

@Deprecated
final class LegacySortedNumericDocValuesWrapper
extends SortedNumericDocValues {
    private final LegacySortedNumericDocValues values;
    private final int maxDoc;
    private int docID = -1;
    private int upto;

    public LegacySortedNumericDocValuesWrapper(LegacySortedNumericDocValues values, int maxDoc) {
        this.values = values;
        this.maxDoc = maxDoc;
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() {
        assert (this.docID != Integer.MAX_VALUE);
        do {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                this.docID = Integer.MAX_VALUE;
                break;
            }
            this.values.setDocument(this.docID);
        } while (this.values.count() == 0);
        this.upto = 0;
        return this.docID;
    }

    public int advance(int target) {
        if (target < this.docID) {
            throw new IllegalArgumentException("cannot advance backwards: docID=" + this.docID + " target=" + target);
        }
        if (target >= this.maxDoc) {
            this.docID = Integer.MAX_VALUE;
        } else {
            this.docID = target - 1;
            this.nextDoc();
        }
        return this.docID;
    }

    public boolean advanceExact(int target) throws IOException {
        this.docID = target;
        this.values.setDocument(this.docID);
        this.upto = 0;
        return this.values.count() != 0;
    }

    public long cost() {
        return 0L;
    }

    public long nextValue() {
        return this.values.valueAt(this.upto++);
    }

    public int docValueCount() {
        return this.values.count();
    }
}

