/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.carrot2.mahout.math.function.DoubleFunction;
import org.carrot2.mahout.math.function.Functions;
import org.carrot2.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class NonnegativeMatrixFactorizationED
extends IterativeMatrixFactorizationBase {
    public NonnegativeMatrixFactorizationED(DoubleMatrix2D A) {
        super(A);
    }

    @Override
    public void compute() {
        double eps = 1.0E-9;
        this.U = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        this.V = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DenseDoubleMatrix2D T = new DenseDoubleMatrix2D(this.k, this.k);
        DenseDoubleMatrix2D UT1 = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        DenseDoubleMatrix2D UT2 = new DenseDoubleMatrix2D(this.A.rows(), this.k);
        DenseDoubleMatrix2D VT1 = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        DenseDoubleMatrix2D VT2 = new DenseDoubleMatrix2D(this.A.columns(), this.k);
        DoubleFunction plusEps = Functions.plus(eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.U, T, 1.0, 0.0, true, false);
            this.A.zMult(this.U, VT1, 1.0, 0.0, true, false);
            this.V.zMult(T, VT2, 1.0, 0.0, false, false);
            ((DoubleMatrix2D)VT1).assign(plusEps);
            ((DoubleMatrix2D)VT2).assign(plusEps);
            ((DoubleMatrix2D)VT1).assign(VT2, Functions.DIV);
            this.V.assign(VT1, Functions.MULT);
            this.V.zMult(this.V, T, 1.0, 0.0, true, false);
            this.A.zMult(this.V, UT1, 1.0, 0.0, false, false);
            this.U.zMult(T, UT2, 1.0, 0.0, false, false);
            ((DoubleMatrix2D)UT1).assign(plusEps);
            ((DoubleMatrix2D)UT2).assign(plusEps);
            ((DoubleMatrix2D)UT1).assign(UT2, Functions.DIV);
            this.U.assign(UT1, Functions.MULT);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "NMF-ED-" + this.seedingStrategy.toString();
    }
}

