/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class CaseNormalizerDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.preprocessing.CaseNormalizer";
    public final String prefix = "CaseNormalizer";
    public final String title = "Performs case normalization and calculates a number of frequency statistics for words";
    public final String label = "";
    public final String description = "The aim of case normalization is to find the most frequently appearing variants of words in terms of case. For example, if in the input documents <i>MacOS</i> appears 20 times, <i>Macos</i> 5 times and <i>macos</i> 2 times, case normalizer will select <i>MacOS</i> to represent all variants and assign the aggregated term frequency of 27 to it. <p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllTokens.wordIndex</code></li> <li><code>AllWords.image</code></li> <li><code>AllWords.tf</code></li> <li><code>AllWords.tfByDocument</code></li> </ul> <p> This class requires that <code>Tokenizer</code> be invoked first.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "CaseNormalizer";
    }

    public String getTitle() {
        return "Performs case normalization and calculates a number of frequency statistics for words";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "The aim of case normalization is to find the most frequently appearing variants of words in terms of case. For example, if in the input documents <i>MacOS</i> appears 20 times, <i>Macos</i> 5 times and <i>macos</i> 2 times, case normalizer will select <i>MacOS</i> to represent all variants and assign the aggregated term frequency of 27 to it. <p> This class saves the following results to the <code>PreprocessingContext</code>: <ul> <li><code>AllTokens.wordIndex</code></li> <li><code>AllWords.image</code></li> <li><code>AllWords.tf</code></li> <li><code>AllWords.tfByDocument</code></li> </ul> <p> This class requires that <code>Tokenizer</code> be invoked first.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(CaseNormalizerDescriptor.attributes.dfThreshold);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(CaseNormalizerDescriptor.attributes.dfThreshold);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder dfThreshold(int value) {
            this.map.put("CaseNormalizer.dfThreshold", value);
            return this;
        }

        public AttributeBuilder dfThreshold(IObjectFactory<? extends Integer> value) {
            this.map.put("CaseNormalizer.dfThreshold", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo dfThreshold = new AttributeInfo("CaseNormalizer.dfThreshold", "org.carrot2.text.preprocessing.CaseNormalizer", "dfThreshold", "Word Document Frequency threshold. Words appearing in fewer than\n<code>dfThreshold</code> documents will be ignored.", "Word document frequency threshold", "Word Document Frequency threshold", "Words appearing in fewer than <code>dfThreshold</code> documents will be ignored.", "Preprocessing", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String DF_THRESHOLD = "CaseNormalizer.dfThreshold";

        protected Keys() {
        }
    }
}

