/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.util;

import java.util.Comparator;

public class CharArrayComparators {
    public static final Comparator<char[]> CASE_INSENSITIVE_CHAR_ARRAY_COMPARATOR = new Comparator<char[]>(){

        @Override
        public final int compare(char[] a1, char[] a2) {
            if (a1 == null) {
                if (a2 == null) {
                    return 0;
                }
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            int l1 = a1.length;
            int l2 = a2.length;
            int n = l1 < l2 ? l1 : l2;
            for (int i = 0; i < n; ++i) {
                int d;
                int c = Character.toLowerCase((int)a1[i]);
                if (c == (d = Character.toLowerCase((int)a2[i]))) continue;
                return c - d;
            }
            return l1 - l2;
        }
    };
    public static final Comparator<char[]> FAST_CHAR_ARRAY_COMPARATOR = new Comparator<char[]>(){

        @Override
        public final int compare(char[] a1, char[] a2) {
            if (a1 == null) {
                if (a2 == null) {
                    return 0;
                }
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            int l1 = a1.length;
            int l2 = a2.length;
            int n = l1 < l2 ? l1 : l2;
            for (int i = 0; i < n; ++i) {
                char a1I = a1[i];
                char a2I = a2[i];
                if (a1I == a2I) continue;
                return a1I - a2I;
            }
            return l1 - l2;
        }
    };
    public static final Comparator<char[]> NORMALIZING_CHAR_ARRAY_COMPARATOR = new Comparator<char[]>(){

        @Override
        public final int compare(char[] a1, char[] a2) {
            int i;
            if (a1 == null) {
                if (a2 == null) {
                    return 0;
                }
                return 1;
            }
            if (a2 == null) {
                return -1;
            }
            if (a1 == a2) {
                return 0;
            }
            int l1 = a1.length;
            int l2 = a2.length;
            if (l1 != l2) {
                return l1 - l2;
            }
            for (i = 0; i < l1; ++i) {
                int d;
                int c = Character.toLowerCase((int)a1[i]);
                if (c == (d = Character.toLowerCase((int)a2[i]))) continue;
                return c - d;
            }
            for (i = 0; i < l1; ++i) {
                char a1I = a1[i];
                char a2I = a2[i];
                if (a1I == a2I) continue;
                return a2I - a1I;
            }
            return 0;
        }
    };

    private CharArrayComparators() {
    }
}

