/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.tools.RelBuilderFactory;

public class EnumerableFilterToCalcRule
extends RelOptRule {
    public EnumerableFilterToCalcRule(RelBuilderFactory relBuilderFactory) {
        super(EnumerableFilterToCalcRule.operand(EnumerableFilter.class, EnumerableFilterToCalcRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        EnumerableFilter filter = (EnumerableFilter)call.rel(0);
        RelNode input = filter.getInput();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelDataType inputRowType = input.getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(filter.getCondition());
        RexProgram program = programBuilder.getProgram();
        EnumerableCalc calc = EnumerableCalc.create(input, program);
        call.transformTo(calc);
    }
}

