/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public class SqlJsonQueryFunction
extends SqlFunction {
    public SqlJsonQueryFunction() {
        super("JSON_QUERY", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.VARCHAR_2000, SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY), SqlFunctionCategory.SYSTEM);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        return "{0}({1} {2} WRAPPER {3} ON EMPTY {4} ON ERROR)";
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        SqlJsonQueryWrapperBehavior wrapperBehavior = (SqlJsonQueryWrapperBehavior)((Object)this.getEnumValue((SqlNode)call.operand(1)));
        switch (wrapperBehavior) {
            case WITHOUT_ARRAY: {
                writer.keyword("WITHOUT ARRAY");
                break;
            }
            case WITH_CONDITIONAL_ARRAY: {
                writer.keyword("WITH CONDITIONAL ARRAY");
                break;
            }
            case WITH_UNCONDITIONAL_ARRAY: {
                writer.keyword("WITH UNCONDITIONAL ARRAY");
                break;
            }
            default: {
                throw new IllegalStateException("unreachable code");
            }
        }
        writer.keyword("WRAPPER");
        this.unparseEmptyOrErrorBehavior(writer, (SqlJsonQueryEmptyOrErrorBehavior)((Object)this.getEnumValue((SqlNode)call.operand(2))));
        writer.keyword("ON EMPTY");
        this.unparseEmptyOrErrorBehavior(writer, (SqlJsonQueryEmptyOrErrorBehavior)((Object)this.getEnumValue((SqlNode)call.operand(3))));
        writer.keyword("ON ERROR");
        writer.endFunCall(frame);
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        if (operands[1] == null) {
            operands[1] = SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, pos);
        }
        if (operands[2] == null) {
            operands[2] = SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, pos);
        }
        if (operands[3] == null) {
            operands[3] = SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, pos);
        }
        return super.createCall(functionQualifier, pos, operands);
    }

    private void unparseEmptyOrErrorBehavior(SqlWriter writer, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior) {
        switch (emptyBehavior) {
            case NULL: {
                writer.keyword("NULL");
                break;
            }
            case ERROR: {
                writer.keyword("ERROR");
                break;
            }
            case EMPTY_ARRAY: {
                writer.keyword("EMPTY ARRAY");
                break;
            }
            case EMPTY_OBJECT: {
                writer.keyword("EMPTY OBJECT");
                break;
            }
            default: {
                throw new IllegalStateException("unreachable code");
            }
        }
    }

    private <E extends Enum<E>> E getEnumValue(SqlNode operand) {
        return (E)((Enum)((SqlLiteral)operand).getValue());
    }
}

