/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import com.google.common.collect.ImmutableSet;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;

public class DeduplicateCorrelateVariables
extends RelHomogeneousShuttle {
    private final RexShuttle dedupRex;

    private DeduplicateCorrelateVariables(RexBuilder builder, CorrelationId canonicalId, ImmutableSet<CorrelationId> alternateIds) {
        this.dedupRex = new DeduplicateCorrelateVariablesShuttle(builder, canonicalId, alternateIds, this);
    }

    public static RelNode go(RexBuilder builder, CorrelationId canonicalId, Iterable<? extends CorrelationId> alternateIds, RelNode r) {
        return r.accept(new DeduplicateCorrelateVariables(builder, canonicalId, (ImmutableSet<CorrelationId>)ImmutableSet.copyOf(alternateIds)));
    }

    @Override
    public RelNode visit(RelNode other) {
        RelNode next = super.visit(other);
        return next.accept(this.dedupRex);
    }

    private static class DeduplicateCorrelateVariablesShuttle
    extends RexShuttle {
        private final RexBuilder builder;
        private final CorrelationId canonicalId;
        private final ImmutableSet<CorrelationId> alternateIds;
        private final DeduplicateCorrelateVariables shuttle;

        private DeduplicateCorrelateVariablesShuttle(RexBuilder builder, CorrelationId canonicalId, ImmutableSet<CorrelationId> alternateIds, DeduplicateCorrelateVariables shuttle) {
            this.builder = builder;
            this.canonicalId = canonicalId;
            this.alternateIds = alternateIds;
            this.shuttle = shuttle;
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            if (!this.alternateIds.contains((Object)variable.id)) {
                return variable;
            }
            return this.builder.makeCorrel(variable.getType(), this.canonicalId);
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            RelNode r;
            if (this.shuttle != null && (r = subQuery.rel.accept(this.shuttle)) != subQuery.rel) {
                subQuery = subQuery.clone(r);
            }
            return super.visitSubQuery(subQuery);
        }
    }
}

