/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.IntConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.common.SolrException;

class IntStreamReplaceFunction
extends IntValueStream.AbstractIntValueStream {
    private final IntValueStream baseExpr;
    private final IntValue compExpr;
    private final IntValue fillExpr;
    public static final String name = "replace";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public IntStreamReplaceFunction(IntValueStream baseExpr, IntValue compExpr, IntValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
    }

    @Override
    public void streamInts(IntConsumer cons) {
        int compValue = this.compExpr.getInt();
        if (this.compExpr.exists()) {
            int fillValue = this.fillExpr.getInt();
            boolean fillExists = this.fillExpr.exists();
            this.baseExpr.streamInts(value -> {
                if (value == compValue) {
                    if (fillExists) {
                        cons.accept(fillValue);
                    }
                } else {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamInts(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

