/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.IncludeEventHandler;
import org.apache.velocity.app.event.InvalidReferenceEventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalEventContext;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCartridge {
    private List<ReferenceInsertionEventHandler> referenceHandlers = new ArrayList<ReferenceInsertionEventHandler>();
    private MethodExceptionEventHandler methodExceptionHandler = null;
    private List<IncludeEventHandler> includeHandlers = new ArrayList<IncludeEventHandler>();
    private List<InvalidReferenceEventHandler> invalidReferenceHandlers = new ArrayList<InvalidReferenceEventHandler>();
    Set initializedHandlers = new HashSet();
    protected RuntimeServices rsvc = null;

    protected Logger getLog() {
        return this.rsvc == null ? LoggerFactory.getLogger(EventCartridge.class) : this.rsvc.getLog();
    }

    public synchronized void setRuntimeServices(RuntimeServices runtimeServices) {
        if (this.rsvc == null) {
            this.rsvc = runtimeServices;
            for (EventHandler eventHandler : this.referenceHandlers) {
                if (!(eventHandler instanceof RuntimeServicesAware) || this.initializedHandlers.contains(eventHandler)) continue;
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(runtimeServices);
                this.initializedHandlers.add(eventHandler);
            }
            if (this.methodExceptionHandler != null && this.methodExceptionHandler instanceof RuntimeServicesAware && !this.initializedHandlers.contains(this.methodExceptionHandler)) {
                ((RuntimeServicesAware)((Object)this.methodExceptionHandler)).setRuntimeServices(runtimeServices);
                this.initializedHandlers.add(this.methodExceptionHandler);
            }
            for (EventHandler eventHandler : this.includeHandlers) {
                if (!(eventHandler instanceof RuntimeServicesAware) || this.initializedHandlers.contains(eventHandler)) continue;
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(runtimeServices);
                this.initializedHandlers.add(eventHandler);
            }
            for (EventHandler eventHandler : this.invalidReferenceHandlers) {
                if (!(eventHandler instanceof RuntimeServicesAware) || this.initializedHandlers.contains(eventHandler)) continue;
                ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(runtimeServices);
                this.initializedHandlers.add(eventHandler);
            }
        } else if (this.rsvc != runtimeServices) {
            throw new VelocityException("an event cartridge cannot be used by several different runtime services instances");
        }
    }

    public boolean addEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            return false;
        }
        boolean bl = false;
        if (eventHandler instanceof ReferenceInsertionEventHandler) {
            this.addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)eventHandler);
            bl = true;
        }
        if (eventHandler instanceof MethodExceptionEventHandler) {
            this.addMethodExceptionHandler((MethodExceptionEventHandler)eventHandler);
            bl = true;
        }
        if (eventHandler instanceof IncludeEventHandler) {
            this.addIncludeEventHandler((IncludeEventHandler)eventHandler);
            bl = true;
        }
        if (eventHandler instanceof InvalidReferenceEventHandler) {
            this.addInvalidReferenceEventHandler((InvalidReferenceEventHandler)eventHandler);
            bl = true;
        }
        if (bl && this.rsvc != null && eventHandler instanceof RuntimeServicesAware && !this.initializedHandlers.contains(eventHandler)) {
            ((RuntimeServicesAware)((Object)eventHandler)).setRuntimeServices(this.rsvc);
            this.initializedHandlers.add(eventHandler);
        }
        return bl;
    }

    public void addReferenceInsertionEventHandler(ReferenceInsertionEventHandler referenceInsertionEventHandler) {
        this.referenceHandlers.add(referenceInsertionEventHandler);
    }

    public void addMethodExceptionHandler(MethodExceptionEventHandler methodExceptionEventHandler) {
        if (this.methodExceptionHandler == null) {
            this.methodExceptionHandler = methodExceptionEventHandler;
        } else {
            this.getLog().warn("ignoring extra method exception handler");
        }
    }

    public void addIncludeEventHandler(IncludeEventHandler includeEventHandler) {
        this.includeHandlers.add(includeEventHandler);
    }

    public void addInvalidReferenceEventHandler(InvalidReferenceEventHandler invalidReferenceEventHandler) {
        this.invalidReferenceHandlers.add(invalidReferenceEventHandler);
    }

    public boolean removeEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            return false;
        }
        if (eventHandler instanceof ReferenceInsertionEventHandler) {
            return this.referenceHandlers.remove(eventHandler);
        }
        if (eventHandler instanceof MethodExceptionEventHandler && eventHandler == this.methodExceptionHandler) {
            this.methodExceptionHandler = null;
            return true;
        }
        if (eventHandler instanceof IncludeEventHandler) {
            return this.includeHandlers.remove(eventHandler);
        }
        if (eventHandler instanceof InvalidReferenceEventHandler) {
            return this.invalidReferenceHandlers.remove(eventHandler);
        }
        return false;
    }

    public Object referenceInsert(InternalContextAdapter internalContextAdapter, String string, Object object) {
        for (ReferenceInsertionEventHandler referenceInsertionEventHandler : this.referenceHandlers) {
            object = referenceInsertionEventHandler.referenceInsert(internalContextAdapter, string, object);
        }
        return object;
    }

    boolean hasMethodExceptionEventHandler() {
        return this.methodExceptionHandler != null;
    }

    public Object methodException(Context context, Class clazz, String string, Exception exception, Info info) {
        if (this.methodExceptionHandler != null) {
            return this.methodExceptionHandler.methodException(context, clazz, string, exception, info);
        }
        return null;
    }

    public String includeEvent(Context context, String string, String string2, String string3) {
        IncludeEventHandler includeEventHandler;
        Iterator<IncludeEventHandler> iterator = this.includeHandlers.iterator();
        while (iterator.hasNext() && (string = (includeEventHandler = iterator.next()).includeEvent(context, string, string2, string3)) != null) {
        }
        return string;
    }

    public Object invalidGetMethod(Context context, String string, Object object, String string2, Info info) {
        InvalidReferenceEventHandler invalidReferenceEventHandler;
        Object object2 = null;
        Iterator<InvalidReferenceEventHandler> iterator = this.invalidReferenceHandlers.iterator();
        while (iterator.hasNext() && (object2 = (invalidReferenceEventHandler = iterator.next()).invalidGetMethod(context, string, object, string2, info)) == null) {
        }
        return object2;
    }

    public boolean invalidSetMethod(Context context, String string, String string2, Info info) {
        for (InvalidReferenceEventHandler invalidReferenceEventHandler : this.invalidReferenceHandlers) {
            if (!invalidReferenceEventHandler.invalidSetMethod(context, string, string2, info)) continue;
            return true;
        }
        return false;
    }

    public Object invalidMethod(Context context, String string, Object object, String string2, Info info) {
        InvalidReferenceEventHandler invalidReferenceEventHandler;
        Object object2 = null;
        Iterator<InvalidReferenceEventHandler> iterator = this.invalidReferenceHandlers.iterator();
        while (iterator.hasNext() && (object2 = (invalidReferenceEventHandler = iterator.next()).invalidMethod(context, string, object, string2, info)) == null) {
        }
        return object2;
    }

    public final boolean attachToContext(Context context) {
        if (context instanceof InternalEventContext) {
            InternalEventContext internalEventContext = (InternalEventContext)((Object)context);
            internalEventContext.attachEventCartridge(this);
            return true;
        }
        return false;
    }
}

