/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.ner.NERecogniser;
import org.apache.tika.parser.ner.opennlp.OpenNLPNERecogniser;
import org.apache.tika.parser.ner.regex.RegexNERecogniser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class NamedEntityParser
extends AbstractParser {
    public static final Logger LOG = LoggerFactory.getLogger(NamedEntityParser.class);
    public static final Set<MediaType> MEDIA_TYPES = new HashSet<MediaType>();
    public static final String MD_KEY_PREFIX = "NER_";
    public static final String DEFAULT_NER_IMPL = OpenNLPNERecogniser.class.getName() + "," + RegexNERecogniser.class.getName();
    public static final String SYS_PROP_NER_IMPL = "ner.impl.class";
    public Tika secondaryParser;
    private List<NERecogniser> nerChain;
    private volatile boolean initialized = false;
    private volatile boolean available = false;

    private synchronized void initialize(ParseContext context) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String classNamesString = System.getProperty(SYS_PROP_NER_IMPL, DEFAULT_NER_IMPL);
        String[] classNames = classNamesString.split(",");
        this.nerChain = new ArrayList<NERecogniser>(classNames.length);
        for (String className : classNames) {
            className = className.trim();
            LOG.info("going to load, instantiate and bind the instance of {}", (Object)className);
            try {
                NERecogniser recogniser = (NERecogniser)Class.forName(className).newInstance();
                LOG.info("{} is available ? {}", (Object)className, (Object)recogniser.isAvailable());
                if (!recogniser.isAvailable()) continue;
                this.nerChain.add(recogniser);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            TikaConfig config = new TikaConfig();
            this.secondaryParser = new Tika(config);
            this.available = !this.nerChain.isEmpty();
            LOG.info("Number of NERecognisers in chain {}", (Object)this.nerChain.size());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.available = false;
        }
    }

    public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
        return MEDIA_TYPES;
    }

    public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) throws IOException, SAXException, TikaException {
        if (!this.initialized) {
            this.initialize(parseContext);
        }
        if (!this.available) {
            return;
        }
        Reader reader = MediaType.TEXT_PLAIN.toString().equals(metadata.get("Content-Type")) ? new InputStreamReader(inputStream, StandardCharsets.UTF_8) : this.secondaryParser.parse(inputStream);
        String text = IOUtils.toString((Reader)reader);
        IOUtils.closeQuietly((Reader)reader);
        for (NERecogniser ner : this.nerChain) {
            Map<String, Set<String>> names = ner.recognise(text);
            if (names == null) continue;
            for (Map.Entry<String, Set<String>> entry : names.entrySet()) {
                if (entry.getValue() == null) continue;
                String mdKey = MD_KEY_PREFIX + entry.getKey();
                for (String name : entry.getValue()) {
                    metadata.add(mdKey, name);
                }
            }
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(contentHandler, metadata);
        this.extractOutput(text.trim(), xhtml);
    }

    private void extractOutput(String content, XHTMLContentHandler xhtml) throws SAXException {
        xhtml.startDocument();
        xhtml.startElement("div");
        xhtml.characters(content);
        xhtml.endElement("div");
        xhtml.endDocument();
    }

    static {
        MEDIA_TYPES.add(MediaType.TEXT_PLAIN);
    }
}

