/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.generators;

import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.StringGenerator;
import java.util.Random;

public class CodepointSetGenerator
extends StringGenerator {
    final int[] bmp;
    final int[] supplementary;
    final int[] all;

    public CodepointSetGenerator(char[] chars) {
        this.bmp = new int[chars.length];
        this.supplementary = new int[0];
        for (int i = 0; i < chars.length; ++i) {
            this.bmp[i] = chars[i] & 0xFFFF;
            if (!this.isSurrogate(chars[i])) continue;
            throw new IllegalArgumentException("Value is part of a surrogate pair: 0x" + Integer.toHexString(this.bmp[i]));
        }
        this.all = this.concat(this.bmp, this.supplementary);
        if (this.all.length == 0) {
            throw new IllegalArgumentException("Empty set of characters?");
        }
    }

    public CodepointSetGenerator(String s) {
        int i;
        int codepoint;
        int bmps = 0;
        int supplementaries = 0;
        for (i = 0; i < s.length(); i += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codepoint)) {
                ++supplementaries;
                continue;
            }
            ++bmps;
        }
        this.bmp = new int[bmps];
        this.supplementary = new int[supplementaries];
        for (i = 0; i < s.length(); i += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(i);
            if (Character.isSupplementaryCodePoint(codepoint)) {
                this.supplementary[--supplementaries] = codepoint;
                continue;
            }
            this.bmp[--bmps] = codepoint;
        }
        this.all = this.concat(this.bmp, this.supplementary);
        if (this.all.length == 0) {
            throw new IllegalArgumentException("Empty set of characters?");
        }
    }

    @Override
    public String ofCodeUnitsLength(Random r, int minCodeUnits, int maxCodeUnits) {
        int length = RandomNumbers.randomIntBetween(r, minCodeUnits, maxCodeUnits);
        if (this.bmp.length == 0 && this.isOdd(length)) {
            if (minCodeUnits == maxCodeUnits) {
                throw new IllegalArgumentException("Cannot return an odd number of code units  when surrogate pairs are the only available codepoints.");
            }
            length = length == minCodeUnits ? ++length : --length;
        }
        int[] codepoints = new int[length];
        int actual = 0;
        while (length > 0) {
            codepoints[actual] = length == 1 ? this.bmp[r.nextInt(this.bmp.length)] : this.all[r.nextInt(this.all.length)];
            length = Character.isSupplementaryCodePoint(codepoints[actual]) ? (length -= 2) : --length;
            ++actual;
        }
        return new String(codepoints, 0, actual);
    }

    @Override
    public String ofCodePointsLength(Random r, int minCodePoints, int maxCodePoints) {
        int length = RandomNumbers.randomIntBetween(r, minCodePoints, maxCodePoints);
        int[] codepoints = new int[length];
        while (length > 0) {
            codepoints[--length] = this.all[r.nextInt(this.all.length)];
        }
        return new String(codepoints, 0, codepoints.length);
    }

    private boolean isOdd(int v) {
        return (v & 1) != 0;
    }

    private int[] concat(int[] ... arrays) {
        int totalLength = 0;
        for (int[] a : arrays) {
            totalLength += a.length;
        }
        int[] concat = new int[totalLength];
        int i = 0;
        for (int j = 0; j < arrays.length; ++j) {
            System.arraycopy(arrays[j], 0, concat, i, arrays[j].length);
            i += arrays[j].length;
        }
        return concat;
    }

    private boolean isSurrogate(char chr) {
        return chr >= '\ud800' && chr <= '\udfff';
    }
}

