/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;

public final class WindowDefinitionNode
extends WindowNode {
    private boolean inlined;
    private OrderByList orderByList;

    public void init(Object object, Object object2) throws StandardException {
        String string = (String)object;
        this.orderByList = (OrderByList)object2;
        if (string != null) {
            super.init(object);
            this.inlined = false;
        } else {
            super.init("IN-LINE");
            this.inlined = true;
        }
        if (this.orderByList != null) {
            throw StandardException.newException("0A000.S", "WINDOW/ORDER BY");
        }
    }

    public String toString() {
        return "name: " + this.getName() + "\n" + "inlined: " + this.inlined + "\n" + "()\n";
    }

    public void printSubNodes(int n) {
    }

    public WindowDefinitionNode findEquivalentWindow(WindowList windowList) {
        for (int i = 0; i < windowList.size(); ++i) {
            WindowDefinitionNode windowDefinitionNode = (WindowDefinitionNode)windowList.elementAt(i);
            if (!this.isEquivalent(windowDefinitionNode)) continue;
            return windowDefinitionNode;
        }
        return null;
    }

    private boolean isEquivalent(WindowDefinitionNode windowDefinitionNode) {
        return this.orderByList == null && windowDefinitionNode.getOrderByList() == null;
    }

    public OrderByList getOrderByList() {
        return this.orderByList;
    }
}

