/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;

public class DataFrame
extends Frame {
    private final int streamId;
    private final ByteBuffer data;
    private final boolean endStream;
    private final int padding;

    public DataFrame(int streamId, ByteBuffer data, boolean endStream) {
        this(streamId, data, endStream, 0);
    }

    public DataFrame(int streamId, ByteBuffer data, boolean endStream, int padding) {
        super(FrameType.DATA);
        this.streamId = streamId;
        this.data = data;
        this.endStream = endStream;
        this.padding = padding;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public int remaining() {
        return this.data.remaining();
    }

    public int padding() {
        return this.padding;
    }

    @Override
    public String toString() {
        return String.format("%s#%d{length:%d,end=%b}", super.toString(), this.streamId, this.data.remaining(), this.endStream);
    }
}

