/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.solr.ltr.FeatureLogger;
import org.apache.solr.ltr.LTRScoringQuery;
import org.apache.solr.search.SolrIndexSearcher;

public class LTRRescorer
extends Rescorer {
    LTRScoringQuery scoringQuery;

    public LTRRescorer(LTRScoringQuery scoringQuery) {
        this.scoringQuery = scoringQuery;
    }

    private void heapAdjust(ScoreDoc[] hits, int size, int root) {
        ScoreDoc doc = hits[root];
        float score = doc.score;
        int i = root;
        while (i <= (size >> 1) - 1) {
            int lchild = (i << 1) + 1;
            ScoreDoc ldoc = hits[lchild];
            float lscore = ldoc.score;
            float rscore = Float.MAX_VALUE;
            int rchild = (i << 1) + 2;
            ScoreDoc rdoc = null;
            if (rchild < size) {
                rdoc = hits[rchild];
                rscore = rdoc.score;
            }
            if (lscore < score) {
                if (rscore < lscore) {
                    hits[i] = rdoc;
                    hits[rchild] = doc;
                    i = rchild;
                    continue;
                }
                hits[i] = ldoc;
                hits[lchild] = doc;
                i = lchild;
                continue;
            }
            if (rscore < score) {
                hits[i] = rdoc;
                hits[rchild] = doc;
                i = rchild;
                continue;
            }
            return;
        }
    }

    private void heapify(ScoreDoc[] hits, int size) {
        for (int i = (size >> 1) - 1; i >= 0; --i) {
            this.heapAdjust(hits, size, i);
        }
    }

    public TopDocs rescore(IndexSearcher searcher, TopDocs firstPassTopDocs, int topN) throws IOException {
        if (topN == 0 || firstPassTopDocs.scoreDocs.length == 0) {
            return firstPassTopDocs;
        }
        ScoreDoc[] hits = firstPassTopDocs.scoreDocs;
        Arrays.sort(hits, new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc a, ScoreDoc b) {
                return a.doc - b.doc;
            }
        });
        assert (firstPassTopDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
        topN = Math.toIntExact(Math.min((long)topN, firstPassTopDocs.totalHits.value));
        ScoreDoc[] reranked = new ScoreDoc[topN];
        List leaves = searcher.getIndexReader().leaves();
        LTRScoringQuery.ModelWeight modelWeight = (LTRScoringQuery.ModelWeight)searcher.createWeight(searcher.rewrite((Query)this.scoringQuery), ScoreMode.COMPLETE, 1.0f);
        this.scoreFeatures(searcher, firstPassTopDocs, topN, modelWeight, hits, leaves, reranked);
        Arrays.sort(reranked, new Comparator<ScoreDoc>(){

            @Override
            public int compare(ScoreDoc a, ScoreDoc b) {
                if (a.score > b.score) {
                    return -1;
                }
                if (a.score < b.score) {
                    return 1;
                }
                return a.doc - b.doc;
            }
        });
        return new TopDocs(firstPassTopDocs.totalHits, reranked);
    }

    public void scoreFeatures(IndexSearcher indexSearcher, TopDocs firstPassTopDocs, int topN, LTRScoringQuery.ModelWeight modelWeight, ScoreDoc[] hits, List<LeafReaderContext> leaves, ScoreDoc[] reranked) throws IOException {
        int readerUpto = -1;
        int endDoc = 0;
        int docBase = 0;
        LTRScoringQuery.ModelWeight.ModelScorer scorer = null;
        FeatureLogger featureLogger = this.scoringQuery.getFeatureLogger();
        for (int hitUpto = 0; hitUpto < hits.length; ++hitUpto) {
            ScoreDoc hit = hits[hitUpto];
            int docID = hit.doc;
            LeafReaderContext readerContext = null;
            while (docID >= endDoc) {
                readerContext = leaves.get(++readerUpto);
                endDoc = readerContext.docBase + readerContext.reader().maxDoc();
            }
            if (readerContext != null) {
                docBase = readerContext.docBase;
                scorer = modelWeight.scorer(readerContext);
            }
            assert (scorer != null);
            int targetDoc = docID - docBase;
            scorer.docID();
            scorer.iterator().advance(targetDoc);
            scorer.getDocInfo().setOriginalDocScore(Float.valueOf(hit.score));
            hit.score = scorer.score();
            if (hitUpto < topN) {
                reranked[hitUpto] = hit;
                if (featureLogger != null && indexSearcher instanceof SolrIndexSearcher) {
                    featureLogger.log(hit.doc, this.scoringQuery, (SolrIndexSearcher)indexSearcher, modelWeight.getFeaturesInfo());
                }
            } else if (hitUpto == topN) {
                this.heapify(reranked, topN);
            }
            if (hitUpto < topN || !(hit.score > reranked[0].score)) continue;
            reranked[0] = hit;
            this.heapAdjust(reranked, topN, 0);
            if (featureLogger == null || !(indexSearcher instanceof SolrIndexSearcher)) continue;
            featureLogger.log(hit.doc, this.scoringQuery, (SolrIndexSearcher)indexSearcher, modelWeight.getFeaturesInfo());
        }
    }

    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        List leafContexts = searcher.getTopReaderContext().leaves();
        int n = ReaderUtil.subIndex((int)docID, (List)leafContexts);
        LeafReaderContext context = (LeafReaderContext)leafContexts.get(n);
        int deBasedDoc = docID - context.docBase;
        Weight modelWeight = searcher.createWeight(searcher.rewrite((Query)this.scoringQuery), ScoreMode.COMPLETE, 1.0f);
        return modelWeight.explain(context, deBasedDoc);
    }

    public static LTRScoringQuery.FeatureInfo[] extractFeaturesInfo(LTRScoringQuery.ModelWeight modelWeight, int docid, Float originalDocScore, List<LeafReaderContext> leafContexts) throws IOException {
        int n = ReaderUtil.subIndex((int)docid, leafContexts);
        LeafReaderContext atomicContext = leafContexts.get(n);
        int deBasedDoc = docid - atomicContext.docBase;
        LTRScoringQuery.ModelWeight.ModelScorer r = modelWeight.scorer(atomicContext);
        if (r == null || r.iterator().advance(deBasedDoc) != deBasedDoc) {
            return new LTRScoringQuery.FeatureInfo[0];
        }
        if (originalDocScore != null) {
            r.getDocInfo().setOriginalDocScore(originalDocScore);
        }
        r.score();
        return modelWeight.getFeaturesInfo();
    }
}

