/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Optional;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSource;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files$1;
import java.io.File;
import java.io.FileInputStream;

final class Files$FileByteSource
extends ByteSource {
    private final File file;

    private Files$FileByteSource(File file) {
        this.file = (File)Preconditions.checkNotNull(file);
    }

    @Override
    public FileInputStream openStream() {
        return new FileInputStream(this.file);
    }

    @Override
    public Optional sizeIfKnown() {
        if (this.file.isFile()) {
            return Optional.of(this.file.length());
        }
        return Optional.absent();
    }

    @Override
    public byte[] read() {
        try (Closer closer = Closer.create();){
            FileInputStream fileInputStream = (FileInputStream)closer.register(this.openStream());
            byte[] byArray = ByteStreams.toByteArray(fileInputStream, fileInputStream.getChannel().size());
            return byArray;
        }
    }

    public String toString() {
        return "Files.asByteSource(" + this.file + ")";
    }

    /* synthetic */ Files$FileByteSource(File file, Files$1 files$1) {
        this(file);
    }
}

