/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Instance;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.MapFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.InputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.OutputNode;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Style;
import java.util.Map;

class CompositeMap
implements Converter {
    private final MapFactory factory;
    private final Converter value;
    private final Converter key;
    private final Style style;
    private final Entry entry;

    public CompositeMap(Context context, Entry entry, Type type) {
        this.factory = new MapFactory(context, type);
        this.value = entry.getValue(context);
        this.key = entry.getKey(context);
        this.style = context.getStyle();
        this.entry = entry;
    }

    public Object read(InputNode inputNode) {
        Instance instance = this.factory.getInstance(inputNode);
        Object object = instance.getInstance();
        if (!instance.isReference()) {
            return this.populate(inputNode, object);
        }
        return object;
    }

    public Object read(InputNode inputNode, Object object) {
        Instance instance = this.factory.getInstance(inputNode);
        if (instance.isReference()) {
            return instance.getInstance();
        }
        instance.setInstance(object);
        if (object != null) {
            return this.populate(inputNode, object);
        }
        return object;
    }

    private Object populate(InputNode inputNode, Object object) {
        Map map = (Map)object;
        InputNode inputNode2;
        while ((inputNode2 = inputNode.getNext()) != null) {
            Object object2 = this.key.read(inputNode2);
            Object object3 = this.value.read(inputNode2);
            map.put(object2, object3);
        }
        return map;
    }

    public boolean validate(InputNode inputNode) {
        Instance instance = this.factory.getInstance(inputNode);
        if (!instance.isReference()) {
            Object object = instance.setInstance(null);
            Class clazz = instance.getType();
            return this.validate(inputNode, clazz);
        }
        return true;
    }

    private boolean validate(InputNode inputNode, Class clazz) {
        InputNode inputNode2;
        do {
            if ((inputNode2 = inputNode.getNext()) == null) {
                return true;
            }
            if (this.key.validate(inputNode2)) continue;
            return false;
        } while (this.value.validate(inputNode2));
        return false;
    }

    public void write(OutputNode outputNode, Object object) {
        Map map = (Map)object;
        for (Object k : map.keySet()) {
            String string = this.entry.getEntry();
            String string2 = this.style.getElement(string);
            OutputNode outputNode2 = outputNode.getChild(string2);
            Object v = map.get(k);
            this.key.write(outputNode2, k);
            this.value.write(outputNode2, v);
        }
    }
}

