/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public final class DeclaredMembers {
    private static final Ordering<Class<?>> CLASS_ORDERING = new Ordering<Class<?>>(){

        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Ordering<Field> FIELD_ORDERING = new Ordering<Field>(){

        public int compare(Field left, Field right) {
            return ComparisonChain.start().compare((Comparable)((Object)left.getName()), (Comparable)((Object)right.getName())).compare(left.getType(), right.getType(), (Comparator)CLASS_ORDERING).result();
        }
    };
    private static final Ordering<Method> METHOD_ORDERING = new Ordering<Method>(){

        public int compare(Method left, Method right) {
            return ComparisonChain.start().compare((Comparable)((Object)left.getName()), (Comparable)((Object)right.getName())).compare(left.getReturnType(), right.getReturnType(), (Comparator)CLASS_ORDERING).compare(Arrays.asList(left.getParameterTypes()), Arrays.asList(right.getParameterTypes()), (Comparator)CLASS_ORDERING.lexicographical()).result();
        }
    };

    private DeclaredMembers() {
    }

    public static Field[] getDeclaredFields(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        Arrays.sort(fields, FIELD_ORDERING);
        return fields;
    }

    public static Method[] getDeclaredMethods(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        Arrays.sort(methods, METHOD_ORDERING);
        return methods;
    }
}

