/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.BufferIsEmptyException;
import com.cloudhopper.commons.util.BufferIsFullException;
import com.cloudhopper.commons.util.BufferSizeException;
import com.cloudhopper.commons.util.HexUtil;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBuffer {
    private static final Logger logger = LoggerFactory.getLogger(ByteBuffer.class);
    private static final int DEFAULT_BUFFER_CAPACITY = 1023;
    private static final int MAXIMUM_INTEGER = Integer.MAX_VALUE;
    private byte[] buffer;
    private int currentReadPosition;
    private int currentWritePosition;
    private int currentBufferSize;

    public ByteBuffer() {
        try {
            this.circularByteBufferInitializer(1024, 0, 0, 0);
        }
        catch (IllegalArgumentException e) {
            logger.error("Impossible case reached constructing ByteBuffer");
        }
    }

    public ByteBuffer(int capacity) throws IllegalArgumentException {
        if (capacity + 1 < 2) {
            throw new IllegalArgumentException("Buffer capacity must be >= 1");
        }
        this.circularByteBufferInitializer(capacity + 1, 0, 0, 0);
    }

    public ByteBuffer(byte[] bytes) {
        this(bytes.length == 0 ? 1 : bytes.length);
        try {
            this.add(bytes);
        }
        catch (BufferSizeException e) {
            logger.error("Impossible case reached constructing ByteBuffer");
        }
    }

    public ByteBuffer(byte[] bytes, int capacity) throws IllegalArgumentException {
        this(bytes, 0, bytes.length, capacity);
    }

    public ByteBuffer(byte[] bytes, int offset, int length) throws IllegalArgumentException {
        this(bytes, offset, length, length);
    }

    public ByteBuffer(byte[] bytes, int offset, int length, int capacity) throws IllegalArgumentException {
        this(capacity);
        ByteBuffer.checkOffsetLength(bytes.length, offset, length);
        if (capacity < length) {
            throw new IllegalArgumentException("Buffer capacity (" + capacity + ") must be >= the byte[] length (" + bytes.length + ")");
        }
        try {
            this.add(bytes, offset, length);
        }
        catch (BufferSizeException e) {
            logger.error("Impossible case of BufferSizeException in ByteBuffer constructor", (Throwable)e);
        }
    }

    public ByteBuffer(String string0) throws IllegalArgumentException {
        this(string0, string0.length());
    }

    public ByteBuffer(String string0, int capacity) throws IllegalArgumentException {
        this(capacity);
        byte[] bytes = null;
        try {
            bytes = string0.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Impossible case in BtyeBuffer(String) constructor since ISO-8859-1 should be supported encoding", (Throwable)e);
            throw new IllegalArgumentException("Unsupported encoding exception thrown, should never happen", e);
        }
        if (capacity < bytes.length) {
            throw new IllegalArgumentException("Buffer capacity (" + capacity + ") must be >= string0 length (" + string0.length() + "). ISO-8859-1 conversion to bytes > string length?");
        }
        try {
            this.add(bytes);
        }
        catch (BufferSizeException e) {
            logger.error("Impossible case in BtyeBuffer(String) constructor since capacity should have been ensured", (Throwable)e);
            throw new IllegalArgumentException("BufferSizeException exception thrown, should never happen", e);
        }
    }

    private void circularByteBufferInitializer(int bufferCapacity, int bufferSize, int readPosition, int writePosition) {
        if (bufferCapacity < 2) {
            throw new IllegalArgumentException("Buffer capacity must be greater than 2 !");
        }
        if (bufferSize < 0 || bufferSize > bufferCapacity) {
            throw new IllegalArgumentException("Buffer size must be a value between 0 and " + bufferCapacity + " !");
        }
        if (readPosition < 0 || readPosition > bufferSize) {
            throw new IllegalArgumentException("Buffer read position must be a value between 0 and " + bufferSize + " !");
        }
        if (writePosition < 0 || writePosition > bufferSize) {
            throw new IllegalArgumentException("Buffer write position must be a value between 0 and " + bufferSize + " !");
        }
        this.buffer = new byte[bufferCapacity];
        this.currentBufferSize = bufferSize;
        this.currentReadPosition = readPosition;
        this.currentWritePosition = writePosition;
    }

    private int modularExponentation(int a, int b, int n) throws IllegalArgumentException {
        int result = 1;
        int maxBinarySize = 32;
        boolean[] b2Binary = new boolean[maxBinarySize];
        int counter = 0;
        while (b > 0) {
            if (counter >= maxBinarySize) {
                throw new IllegalArgumentException("Exponent " + b + " is too big !");
            }
            b2Binary[counter] = b % 2 != 0;
            b /= 2;
            ++counter;
        }
        for (int k = counter - 1; k >= 0; --k) {
            result = result * result % n;
            if (!b2Binary[k]) continue;
            result = result * a % n;
        }
        return result;
    }

    public int size() {
        return this.currentBufferSize;
    }

    public int capacity() {
        return this.buffer.length - 1;
    }

    public int free() {
        return this.capacity() - this.size();
    }

    public boolean isFree(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        return this.free() >= count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.size() == this.capacity();
    }

    public void clear() {
        this.currentReadPosition = 0;
        this.currentWritePosition = 0;
        this.currentBufferSize = 0;
    }

    public void add(byte b) throws BufferIsFullException {
        if (this.isFull()) {
            throw new BufferIsFullException("Buffer is full and has reached maximum capacity (" + this.capacity() + ")");
        }
        this.buffer[this.currentWritePosition] = b;
        this.currentWritePosition = (this.currentWritePosition + 1) % this.buffer.length;
        ++this.currentBufferSize;
    }

    public void add(byte[] bytes) throws BufferSizeException {
        this.add(bytes, 0, bytes.length);
    }

    protected static void checkOffsetLength(int bytesLength, int offset, int length) throws IllegalArgumentException {
        if (offset < 0) {
            throw new IllegalArgumentException("The byte[] offset parameter cannot be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The byte[] length parameter cannot be negative");
        }
        if (offset != 0 && offset >= bytesLength) {
            throw new IllegalArgumentException("The byte[] offset (" + offset + ") must be < the length of the byte[] length (" + bytesLength + ")");
        }
        if (offset + length > bytesLength) {
            throw new IllegalArgumentException("The offset+length (" + (offset + length) + ") would read past the end of the byte[] (length=" + bytesLength + ")");
        }
    }

    public void add(byte[] bytes, int offset, int length) throws IllegalArgumentException, BufferSizeException {
        ByteBuffer.checkOffsetLength(bytes.length, offset, length);
        if (length > this.free()) {
            throw new BufferSizeException("Buffer does not have enough free space (" + this.free() + " bytes) to add " + length + " bytes of data");
        }
        for (int i = 0; i < length; ++i) {
            try {
                this.add(bytes[i + offset]);
                continue;
            }
            catch (BufferIsFullException e) {
                logger.error("Buffer is full even though this method checked its size() ahead of time", (Throwable)e);
                throw new BufferSizeException(e.getMessage());
            }
        }
    }

    public void delete(int count) throws BufferSizeException {
        if (count < 0 || count > this.capacity()) {
            throw new IllegalArgumentException("Can only delete between 0 and " + this.capacity() + " bytes from buffer, you passed in=" + count);
        }
        if (count > this.size()) {
            throw new BufferSizeException("Buffer size (" + this.size() + ") not large enough to delete (" + count + ") bytes");
        }
        this.currentReadPosition = (this.currentReadPosition + count) % this.buffer.length;
        this.currentBufferSize -= count;
    }

    public byte remove() throws BufferIsEmptyException {
        if (this.size() == 0) {
            throw new BufferIsEmptyException("Buffer is empty and no bytes available to remove");
        }
        byte b = this.buffer[this.currentReadPosition];
        this.currentReadPosition = (this.currentReadPosition + 1) % this.buffer.length;
        --this.currentBufferSize;
        return b;
    }

    public byte[] remove(int count) throws BufferSizeException {
        if (count < 0 || count > this.capacity()) {
            throw new IllegalArgumentException("Tried to remove " + count + " bytes from buffer. The count must be a value between 0 and " + this.capacity());
        }
        if (count > this.size()) {
            throw new BufferSizeException("Buffer size (" + this.size() + ") not large enough to remove (" + count + ") bytes");
        }
        byte[] removedBuffer = new byte[count];
        int currentPos = 0;
        int i = 0;
        while (i < count) {
            try {
                removedBuffer[currentPos] = this.remove();
            }
            catch (BufferIsEmptyException e) {
                logger.error("Buffer is empty even though this method checked its size() ahead of time", (Throwable)e);
                throw new BufferSizeException(e.getMessage());
            }
            ++i;
            ++currentPos;
        }
        return removedBuffer;
    }

    public int occurrences(byte b) {
        byte[] bytes = new byte[]{b};
        return this.occurrences(bytes);
    }

    public int occurrences(byte[] bytes) {
        if (bytes.length == 0) {
            return -1;
        }
        int occurrences = 0;
        int currentPos = -1;
        int offset = 0;
        while (offset < this.size() && (currentPos = this.indexOf(bytes, offset)) >= 0) {
            ++occurrences;
            offset = currentPos + bytes.length;
        }
        return occurrences;
    }

    public ByteBuffer copy() {
        return this.copy(0, this.size(), this.size());
    }

    public ByteBuffer copy(int offset, int length) {
        return this.copy(offset, length, length);
    }

    public ByteBuffer copy(int offset, int length, int capacity) {
        if (length == 0) {
            return new ByteBuffer(1);
        }
        ByteBuffer.checkOffsetLength(this.size(), offset, length);
        if (capacity < length) {
            throw new IllegalArgumentException("Capacity must be large enough to hold copied data of size=" + length);
        }
        ByteBuffer copyBuffer = new ByteBuffer(capacity);
        this.toArray(offset, length, copyBuffer.buffer, 0);
        copyBuffer.currentBufferSize = length;
        copyBuffer.currentReadPosition = 0;
        copyBuffer.currentWritePosition = length;
        return copyBuffer;
    }

    private byte getUnchecked(int index) {
        return this.buffer[(this.currentReadPosition + index) % this.buffer.length];
    }

    public byte get(int index) throws IllegalArgumentException, BufferSizeException {
        if (index < 0 || index >= this.capacity()) {
            throw new IllegalArgumentException("The buffer index must be a value between 0 and " + this.capacity() + "!");
        }
        if (index >= this.size()) {
            throw new BufferSizeException("Index " + index + " is >= buffer size of " + this.size());
        }
        return this.buffer[(this.currentReadPosition + index) % this.buffer.length];
    }

    public byte[] toArray() {
        return this.toArray(0, this.size());
    }

    public byte[] toArray(int offset, int length) {
        return this.toArray(offset, length, length);
    }

    public byte[] toArray(int offset, int length, int capacity) {
        ByteBuffer.checkOffsetLength(this.size(), offset, length);
        if (capacity < length) {
            throw new IllegalArgumentException("Capacity must be large enough to hold a byte[] of at least a size=" + length);
        }
        byte[] arrayCopy = new byte[capacity];
        this.toArray(offset, length, arrayCopy, 0);
        return arrayCopy;
    }

    public void toArray(int offset, int length, byte[] targetBuffer, int targetOffset) {
        ByteBuffer.checkOffsetLength(this.size(), offset, length);
        ByteBuffer.checkOffsetLength(targetBuffer.length, targetOffset, length);
        if (targetBuffer.length < length) {
            throw new IllegalArgumentException("TargetBuffer size must be large enough to hold a byte[] of at least a size=" + length);
        }
        if (length > 0) {
            int offsetReadPosition = (this.currentReadPosition + offset) % this.buffer.length;
            int offsetWritePosition = (this.currentReadPosition + offset + length) % this.buffer.length;
            if (offsetReadPosition >= offsetWritePosition) {
                System.arraycopy(this.buffer, offsetReadPosition, targetBuffer, targetOffset, this.buffer.length - offsetReadPosition);
                System.arraycopy(this.buffer, 0, targetBuffer, targetOffset + this.buffer.length - offsetReadPosition, offsetWritePosition);
            } else {
                System.arraycopy(this.buffer, offsetReadPosition, targetBuffer, targetOffset, offsetWritePosition - offsetReadPosition);
            }
        }
    }

    public boolean startsWith(byte[] prefix) {
        if (prefix.length == 0 || prefix.length > this.size()) {
            return false;
        }
        boolean match = true;
        int j = this.currentReadPosition;
        for (int i = 0; match && i < prefix.length; ++i) {
            if (this.buffer[j] != prefix[i]) {
                match = false;
            }
            j = (j + 1) % this.buffer.length;
        }
        return match;
    }

    public boolean endsWith(byte[] prefix) {
        if (prefix.length == 0 || prefix.length > this.size()) {
            return false;
        }
        boolean match = true;
        int j = (this.currentWritePosition - 1 + this.buffer.length) % this.buffer.length;
        for (int i = prefix.length - 1; match && i >= 0; --i) {
            if (this.buffer[j] != prefix[i]) {
                match = false;
            }
            j = (j - 1 + this.buffer.length) % this.buffer.length;
        }
        return match;
    }

    public int indexOf(byte[] bytes) {
        return this.indexOf(bytes, 0);
    }

    public int indexOf(byte[] bytes, int offset) {
        if (bytes.length == 0 || this.size() == 0) {
            return -1;
        }
        if (offset < 0 || offset >= this.size()) {
            throw new IllegalArgumentException("Offset must be a value between 0 and " + this.size() + " (current buffer size)");
        }
        int length = this.size() - bytes.length;
        for (int i = offset; i <= length; ++i) {
            int j;
            for (j = 0; j < bytes.length && this.getUnchecked(i + j) == bytes[j]; ++j) {
            }
            if (j != bytes.length) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        int hashingConstant = 37;
        int hashCode = 629;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hashCode = hashCode * 37 + this.getUnchecked(i);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer toTest = (ByteBuffer)obj;
        if (toTest.size() != this.size()) {
            return false;
        }
        int length = this.size();
        for (int i = 0; i < length; ++i) {
            try {
                if (this.get(i) == toTest.get(i)) continue;
                return false;
            }
            catch (Exception e) {
                logger.error("Impossible case should never happen", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean equals(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        if (bytes.length == 0 && this.size() == 0) {
            return true;
        }
        return this.startsWith(bytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append((char)this.getUnchecked(i));
        }
        return sb.toString();
    }

    public String toHexString() {
        return this.toHexString(0, this.size());
    }

    public String toHexString(int offset, int length) {
        ByteBuffer.checkOffsetLength(this.size(), offset, length);
        if (length == 0 || this.size() == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder(length * 2);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            HexUtil.appendHexString(s, this.getUnchecked(i));
        }
        return s.toString();
    }
}

