/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BasePipelineFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.Main;
import org.traccar.database.StatisticsManager;
import org.traccar.helper.DateUtil;
import org.traccar.model.Position;

public class MainEventHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainEventHandler.class);
    private static final String DEFAULT_LOGGER_ATTRIBUTES = "time,position,speed,course,accuracy,result";
    private final Set<String> connectionlessProtocols = new HashSet<String>();
    private final Set<String> logAttributes = new LinkedHashSet<String>();

    public MainEventHandler() {
        String connectionlessProtocolList = Context.getConfig().getString("status.ignoreOffline");
        if (connectionlessProtocolList != null) {
            this.connectionlessProtocols.addAll(Arrays.asList(connectionlessProtocolList.split("[, ]")));
        }
        this.logAttributes.addAll(Arrays.asList(Context.getConfig().getString("logger.attributes", DEFAULT_LOGGER_ATTRIBUTES).split("[, ]")));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Position) {
            Position position = (Position)msg;
            try {
                Context.getDeviceManager().updateLatestPosition(position);
            }
            catch (SQLException error) {
                LOGGER.warn("Failed to update device", (Throwable)error);
            }
            String uniqueId = Context.getIdentityManager().getById(position.getDeviceId()).getUniqueId();
            StringBuilder builder = new StringBuilder();
            builder.append(MainEventHandler.formatChannel(ctx.channel())).append(" ");
            builder.append("id: ").append(uniqueId);
            Iterator<String> iterator = this.logAttributes.iterator();
            block20: while (iterator.hasNext()) {
                String attribute;
                switch (attribute = iterator.next()) {
                    case "time": {
                        builder.append(", time: ").append(DateUtil.formatDate(position.getFixTime(), false));
                        continue block20;
                    }
                    case "position": {
                        builder.append(", lat: ").append(String.format("%.5f", position.getLatitude()));
                        builder.append(", lon: ").append(String.format("%.5f", position.getLongitude()));
                        continue block20;
                    }
                    case "speed": {
                        if (!(position.getSpeed() > 0.0)) continue block20;
                        builder.append(", speed: ").append(String.format("%.1f", position.getSpeed()));
                        continue block20;
                    }
                    case "course": {
                        builder.append(", course: ").append(String.format("%.1f", position.getCourse()));
                        continue block20;
                    }
                    case "accuracy": {
                        if (!(position.getAccuracy() > 0.0)) continue block20;
                        builder.append(", accuracy: ").append(String.format("%.1f", position.getAccuracy()));
                        continue block20;
                    }
                    case "outdated": {
                        if (!position.getOutdated()) continue block20;
                        builder.append(", outdated");
                        continue block20;
                    }
                    case "invalid": {
                        if (position.getValid()) continue block20;
                        builder.append(", invalid");
                        continue block20;
                    }
                }
                Object value = position.getAttributes().get(attribute);
                if (value == null) continue;
                builder.append(", ").append(attribute).append(": ").append(value);
            }
            LOGGER.info(builder.toString());
            ((StatisticsManager)Main.getInjector().getInstance(StatisticsManager.class)).registerMessageStored(position.getDeviceId(), position.getProtocol());
        }
    }

    private static String formatChannel(Channel channel) {
        return String.format("[%s]", channel.id().asShortText());
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (!(ctx.channel() instanceof DatagramChannel)) {
            LOGGER.info(MainEventHandler.formatChannel(ctx.channel()) + " connected");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.info(MainEventHandler.formatChannel(ctx.channel()) + " disconnected");
        this.closeChannel(ctx.channel());
        if (BasePipelineFactory.getHandler(ctx.pipeline(), HttpRequestDecoder.class) == null && !this.connectionlessProtocols.contains(((BaseProtocolDecoder)ctx.pipeline().get(BaseProtocolDecoder.class)).getProtocolName())) {
            Context.getConnectionManager().removeActiveDevice(ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        while (cause.getCause() != null && cause.getCause() != cause) {
            cause = cause.getCause();
        }
        LOGGER.warn(MainEventHandler.formatChannel(ctx.channel()) + " error", cause);
        this.closeChannel(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            LOGGER.info(MainEventHandler.formatChannel(ctx.channel()) + " timed out");
            this.closeChannel(ctx.channel());
        }
    }

    private void closeChannel(Channel channel) {
        if (!(channel instanceof DatagramChannel)) {
            channel.close();
        }
    }
}

