/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.database.DataManager;
import org.traccar.model.BaseModel;

public class BaseObjectManager<T extends BaseModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseObjectManager.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final DataManager dataManager;
    private Map<Long, T> items;
    private Class<T> baseClass;

    protected BaseObjectManager(DataManager dataManager, Class<T> baseClass) {
        this.dataManager = dataManager;
        this.baseClass = baseClass;
        this.refreshItems();
    }

    protected final void readLock() {
        this.lock.readLock().lock();
    }

    protected final void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected final void writeLock() {
        this.lock.writeLock().lock();
    }

    protected final void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    protected final DataManager getDataManager() {
        return this.dataManager;
    }

    protected final Class<T> getBaseClass() {
        return this.baseClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getById(long itemId) {
        try {
            this.readLock();
            BaseModel baseModel = (BaseModel)this.items.get(itemId);
            return (T)baseModel;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshItems() {
        if (this.dataManager != null) {
            try {
                this.writeLock();
                Collection<T> databaseItems = this.dataManager.getObjects(this.baseClass);
                if (this.items == null) {
                    this.items = new ConcurrentHashMap<Long, T>(databaseItems.size());
                }
                HashSet<Long> databaseItemIds = new HashSet<Long>();
                for (BaseModel item : databaseItems) {
                    databaseItemIds.add(item.getId());
                    if (this.items.containsKey(item.getId())) {
                        this.updateCachedItem(item);
                        continue;
                    }
                    this.addNewItem(item);
                }
                for (Long cachedItemId : this.items.keySet()) {
                    if (databaseItemIds.contains(cachedItemId)) continue;
                    this.removeCachedItem(cachedItemId);
                }
            }
            catch (SQLException error) {
                LOGGER.warn("Error refreshing items", (Throwable)error);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    protected void addNewItem(T item) {
        try {
            this.writeLock();
            this.items.put(((BaseModel)item).getId(), item);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void addItem(T item) throws SQLException {
        this.dataManager.addObject((BaseModel)item);
        this.addNewItem(item);
    }

    protected void updateCachedItem(T item) {
        try {
            this.writeLock();
            this.items.put(((BaseModel)item).getId(), item);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void updateItem(T item) throws SQLException {
        this.dataManager.updateObject((BaseModel)item);
        this.updateCachedItem(item);
    }

    protected void removeCachedItem(long itemId) {
        try {
            this.writeLock();
            this.items.remove(itemId);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void removeItem(long itemId) throws SQLException {
        T item = this.getById(itemId);
        if (item != null) {
            this.dataManager.removeObject(this.baseClass, itemId);
            this.removeCachedItem(itemId);
        }
    }

    public final Collection<T> getItems(Set<Long> itemIds) {
        LinkedList<T> result = new LinkedList<T>();
        for (long itemId : itemIds) {
            T item = this.getById(itemId);
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    public Set<Long> getAllItems() {
        try {
            this.readLock();
            Set<Long> set = this.items.keySet();
            return set;
        }
        finally {
            this.readUnlock();
        }
    }
}

