/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaManager.class);
    private String path;

    public MediaManager(String path) {
        this.path = path;
    }

    private File createFile(String uniqueId, String name) throws IOException {
        Path filePath = Paths.get(this.path, uniqueId, name);
        Path directoryPath = filePath.getParent();
        if (directoryPath != null) {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        return filePath.toFile();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String writeFile(String uniqueId, ByteBuf buf, String extension) {
        if (this.path != null) {
            int size = buf.readableBytes();
            String name = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + extension;
            try (FileOutputStream output = new FileOutputStream(this.createFile(uniqueId, name));){
                String string;
                block15: {
                    FileChannel fileChannel = output.getChannel();
                    try {
                        ByteBuffer byteBuffer = buf.nioBuffer();
                        for (int written = 0; written < size; written += fileChannel.write(byteBuffer)) {
                        }
                        fileChannel.force(false);
                        string = name;
                        if (fileChannel == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (fileChannel != null) {
                            try {
                                fileChannel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    fileChannel.close();
                }
                return string;
            }
            catch (IOException e) {
                LOGGER.warn("Save media file error", (Throwable)e);
            }
        }
        return null;
    }
}

