/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class AutoFonFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        int length;
        if (buf.readableBytes() < 12) {
            return null;
        }
        switch (buf.getUnsignedByte(buf.readerIndex())) {
            case 16: {
                length = 12;
                break;
            }
            case 17: {
                length = 78;
                break;
            }
            case 18: {
                length = 257;
                break;
            }
            case 65: {
                length = 19;
                break;
            }
            case 2: {
                length = 34;
                break;
            }
            default: {
                length = 0;
            }
        }
        if (length != 0 && buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

