/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class EasyTrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("..,").number("(d+),").expression("([^,]{2}),").expression("([AV]),").number("(xx)(xx)(xx),").number("(xx)(xx)(xx),").number("(x)(x{7}),").number("(x)(x{7}),").number("(x{4}),").number("(x{4}),").number("(x{8}),").number("(x+),").number("(d+),").number("(x+),").number("(x+)").groupBegin().number(",(x+)").groupBegin().number(",d+").number(",(d*)").number(",(x+)").number(",(d+.d+)").number(",(d+)").groupEnd("?").groupEnd("?").any().compile();

    public EasyTrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(long status) {
        if ((status & 0x2000000L) != 0L) {
            return "geofenceEnter";
        }
        if ((status & 0x4000000L) != 0L) {
            return "geofenceExit";
        }
        if ((status & 0x8000000L) != 0L) {
            return "lowBattery";
        }
        if ((status & 0x20000000L) != 0L) {
            return "vibration";
        }
        if ((status & Integer.MIN_VALUE) != 0L) {
            return "overspeed";
        }
        if ((status & 0x10000L) != 0L) {
            return "sos";
        }
        if ((status & 0x40000L) != 0L) {
            return "powerCut";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        String type = sentence.substring(20, 22);
        if (type.equals("TX") && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(sentence + "#", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, sentence)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("command", parser.next());
        position.setValid(parser.next().equals("A"));
        DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextHexInt(), parser.nextHexInt(), parser.nextHexInt()).setTime(parser.nextHexInt(), parser.nextHexInt(), parser.nextHexInt());
        position.setTime(dateBuilder.getDate());
        if (BitUtil.check(parser.nextHexInt().intValue(), 3)) {
            position.setLatitude((double)(-parser.nextHexInt().intValue()) / 600000.0);
        } else {
            position.setLatitude((double)parser.nextHexInt().intValue() / 600000.0);
        }
        if (BitUtil.check(parser.nextHexInt().intValue(), 3)) {
            position.setLongitude((double)(-parser.nextHexInt().intValue()) / 600000.0);
        } else {
            position.setLongitude((double)parser.nextHexInt().intValue() / 600000.0);
        }
        position.setSpeed(UnitsConverter.knotsFromKph((double)parser.nextHexInt().intValue() / 100.0));
        double course = (double)parser.nextHexInt().intValue() * 0.01;
        if (course < 360.0) {
            position.setCourse(course);
        }
        long status = parser.nextHexLong();
        position.set("alarm", this.decodeAlarm(status));
        position.set("blocked", (status & 0x80000L) > 0L);
        position.set("ignition", (status & 0x800000L) > 0L);
        position.set("status", status);
        position.set("rssi", parser.nextHexInt());
        position.set("power", parser.nextDouble());
        position.set("fuel", parser.nextHexInt());
        position.set("odometer", parser.nextHexInt() * 100);
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext(4)) {
            position.set("driverUniqueId", parser.next());
            position.set("temp1", (double)parser.nextHexInt().intValue() * 0.01);
            position.set("adc1", parser.nextDouble());
            position.set("sat", parser.nextInt());
        }
        return position;
    }
}

