/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class StarLinkProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_EVENT_REPORT = 6;
    private static final Pattern PATTERN = new PatternBuilder().expression(".").text("SLU").number("(x{6}|d{15}),").number("(d+),").number("(d+),").expression("(.+)").text("*").number("xx").compile();
    private String[] dataTags;
    private DateFormat dateFormat;

    public StarLinkProtocolDecoder(Protocol protocol) {
        super(protocol);
        this.setFormat(Context.getConfig().getString(this.getProtocolName() + ".format", "#EDT#,#EID#,#PDT#,#LAT#,#LONG#,#SPD#,#HEAD#,#ODO#,#IN1#,#IN2#,#IN3#,#IN4#,#OUT1#,#OUT2#,#OUT3#,#OUT4#,#LAC#,#CID#,#VIN#,#VBAT#,#DEST#,#IGN#,#ENG#"));
        this.setDateFormat(Context.getConfig().getString(this.getProtocolName() + ".dateFormat", "yyMMddHHmmss"));
    }

    public void setFormat(String format) {
        this.dataTags = format.split(",");
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = new SimpleDateFormat(dateFormat);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private double parseCoordinate(String value) {
        int minutesIndex = value.indexOf(46) - 2;
        double result = Double.parseDouble(value.substring(1, minutesIndex));
        return value.charAt(0) == '+' ? result : -(result += Double.parseDouble(value.substring(minutesIndex)) / 60.0);
    }

    private String decodeAlarm(int event) {
        switch (event) {
            case 6: {
                return "overspeed";
            }
            case 7: {
                return "geofenceEnter";
            }
            case 8: {
                return "geofenceExit";
            }
            case 9: {
                return "powerCut";
            }
            case 11: {
                return "lowBattery";
            }
            case 26: {
                return "tow";
            }
            case 36: {
                return "sos";
            }
            case 42: {
                return "jamming";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        int type = parser.nextInt(0);
        if (type != 6) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.set("index", parser.nextInt(0));
        String[] data = parser.next().split(",");
        Integer lac = null;
        Integer cid = null;
        int event = 0;
        block44: for (int i = 0; i < Math.min(data.length, this.dataTags.length); ++i) {
            if (data[i].isEmpty()) continue;
            switch (this.dataTags[i]) {
                case "#EDT#": {
                    position.setDeviceTime(this.dateFormat.parse(data[i]));
                    continue block44;
                }
                case "#EID#": {
                    event = Integer.parseInt(data[i]);
                    position.set("alarm", this.decodeAlarm(event));
                    position.set("event", event);
                    if (event == 24) {
                        position.set("ignition", true);
                        continue block44;
                    }
                    if (event != 25) continue block44;
                    position.set("ignition", false);
                    continue block44;
                }
                case "#PDT#": {
                    position.setFixTime(this.dateFormat.parse(data[i]));
                    continue block44;
                }
                case "#LAT#": {
                    position.setLatitude(this.parseCoordinate(data[i]));
                    continue block44;
                }
                case "#LONG#": {
                    position.setLongitude(this.parseCoordinate(data[i]));
                    continue block44;
                }
                case "#SPD#": {
                    position.setSpeed(Double.parseDouble(data[i]));
                    continue block44;
                }
                case "#HEAD#": {
                    position.setCourse(Integer.parseInt(data[i]));
                    continue block44;
                }
                case "#ODO#": {
                    position.set("odometer", (long)(Double.parseDouble(data[i]) * 1000.0));
                    continue block44;
                }
                case "#IN1#": 
                case "#IN2#": 
                case "#IN3#": 
                case "#IN4#": {
                    position.set("in" + this.dataTags[i].charAt(3), Integer.parseInt(data[i]));
                    continue block44;
                }
                case "#OUT1#": 
                case "#OUT2#": 
                case "#OUT3#": 
                case "#OUT4#": {
                    position.set("out" + this.dataTags[i].charAt(3), Integer.parseInt(data[i]));
                    continue block44;
                }
                case "#LAC#": {
                    if (data[i].isEmpty()) continue block44;
                    lac = Integer.parseInt(data[i]);
                    continue block44;
                }
                case "#CID#": {
                    if (data[i].isEmpty()) continue block44;
                    cid = Integer.parseInt(data[i]);
                    continue block44;
                }
                case "#VIN#": {
                    position.set("power", Double.parseDouble(data[i]));
                    continue block44;
                }
                case "#VBAT#": {
                    position.set("battery", Double.parseDouble(data[i]));
                    continue block44;
                }
                case "#DEST#": {
                    position.set("destination", data[i]);
                    continue block44;
                }
                case "#IGN#": {
                    position.set("ignition", data[i].equals("1"));
                    continue block44;
                }
                case "#ENG#": {
                    position.set("engine", data[i].equals("1"));
                    continue block44;
                }
            }
        }
        if (position.getFixTime() == null) {
            this.getLastLocation(position, null);
        }
        if (lac != null && cid != null) {
            position.setNetwork(new Network(CellTower.fromLacCid(lac, cid.intValue())));
        }
        if (event == 20) {
            String rfid = data[data.length - 1];
            if (rfid.matches("0+")) {
                rfid = data[data.length - 2];
            }
            position.set("driverUniqueId", rfid);
        }
        return position;
    }
}

