/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.incremental.storage.LookupMap;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\u0014\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u0012J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010%\u001a\u00020\u0015J\u0012\u0010&\u001a\u00020\u00122\b\b\u0002\u0010'\u001a\u00020!H\u0002J\u0014\u0010(\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "countersFile", "deletedCount", "", "fileToId", "Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "size", "addAll", "", "lookups", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "", "allPaths", "", "addFileIfNeeded", "file", "clean", "doRemoveGarbage", "dump", "lookupSymbols", "flush", "memoryCachesOnly", "", "forceGC", "get", "", "lookupSymbol", "removeGarbageIfNeeded", "force", "removeLookupsFrom", "files", "Lkotlin/sequences/Sequence;", "Companion", "kotlin-build-common"})
public class LookupStorage
extends BasicMapsOwner {
    private final File countersFile;
    private final IdToFileMap idToFile;
    private final FileToIdMap fileToId;
    private final LookupMap lookupMap;
    private volatile int size;
    private volatile int deletedCount;
    private static final double DELETED_TO_SIZE_TRESHOLD;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Collection<Integer> collection = this.lookupMap.get(key);
        if (collection == null) {
            return SetsKt.emptySet();
        }
        Collection<Integer> fileIds = collection;
        Iterable $this$mapNotNull$iv = fileIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            int it = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            File file2 = this.idToFile.get(it);
            if ((file2 != null ? file2.getPath() : null) == null) continue;
            string2 = string2;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void addAll(@NotNull MultiMap<LookupSymbol, String> lookups, @NotNull Set<String> allPaths) {
        Intrinsics.checkNotNullParameter(lookups, (String)"lookups");
        Intrinsics.checkNotNullParameter(allPaths, (String)"allPaths");
        Map pathToId2 = CollectionsKt.keysToMap(kotlin.collections.CollectionsKt.sorted((Iterable)allPaths), (Function1)new Function1<String, Integer>(this){
            final /* synthetic */ LookupStorage this$0;

            public final int invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LookupStorage.access$addFileIfNeeded(this.this$0, new File(it));
            }
            {
                this.this$0 = lookupStorage;
                super(1);
            }
        });
        Set set = lookups.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"lookups.keySet()");
        for (LookupSymbol lookupSymbol : kotlin.collections.CollectionsKt.sorted((Iterable)set)) {
            void $this$mapTo$iv;
            Collection paths;
            LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
            Intrinsics.checkNotNull((Object)lookups.get((Object)lookupSymbol));
            Intrinsics.checkNotNullExpressionValue((Object)paths, (String)"lookups[lookupSymbol]!!");
            Iterable iterable = paths;
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string2 = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Object v = pathToId2.get(it);
                Intrinsics.checkNotNull(v);
                Integer n = ((Number)v).intValue();
                collection.add(n);
            }
            TreeSet fileIds = (TreeSet)destination$iv;
            Collection collection = this.lookupMap.get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            fileIds.addAll(collection);
            this.lookupMap.set(key, fileIds);
        }
    }

    public final synchronized void removeLookupsFrom(@NotNull Sequence<? extends File> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        for (File file2 : files2) {
            Integer n = this.fileToId.get(file2);
            if (n == null) {
                continue;
            }
            int id = n;
            this.idToFile.remove(id);
            this.fileToId.remove(file2);
            int n2 = this.deletedCount;
            this.deletedCount = n2 + 1;
        }
    }

    @Override
    public synchronized void clean() {
        if (this.countersFile.exists()) {
            this.countersFile.delete();
        }
        this.size = 0;
        this.deletedCount = 0;
        super.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        try {
            LookupStorage.removeGarbageIfNeeded$default(this, false, 1, null);
            if (this.size > 0) {
                if (!this.countersFile.exists()) {
                    this.countersFile.getParentFile().mkdirs();
                    this.countersFile.createNewFile();
                }
                FilesKt.writeText$default((File)this.countersFile, (String)("" + this.size + '\n' + this.deletedCount), null, (int)2, null);
            }
        }
        finally {
            super.flush(memoryCachesOnly);
        }
    }

    private final int addFileIfNeeded(File file2) {
        Integer existing = this.fileToId.get(file2);
        if (existing != null) {
            return existing;
        }
        int n = this.size;
        this.size = n + 1;
        int id = n;
        this.fileToId.set(file2, id);
        this.idToFile.set(id, file2);
        return id;
    }

    private final void removeGarbageIfNeeded(boolean force) {
        if (force || this.size > MINIMUM_GARBAGE_COLLECTIBLE_SIZE && (double)this.deletedCount / (double)this.size > DELETED_TO_SIZE_TRESHOLD) {
            this.doRemoveGarbage();
        }
    }

    static /* synthetic */ void removeGarbageIfNeeded$default(LookupStorage lookupStorage, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeGarbageIfNeeded");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        lookupStorage.removeGarbageIfNeeded(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void doRemoveGarbage() {
        boolean $i$f$filterTo2;
        Map.Entry $this$filter$iv;
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void $this$filterTo$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(hash);
            Intrinsics.checkNotNull(collection);
            Iterable iterable = collection;
            LookupSymbolKey lookupSymbolKey = hash;
            LookupMap lookupMap = this.lookupMap;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            lookupMap.set(lookupSymbolKey, kotlin.collections.CollectionsKt.toSet((Iterable)list));
        }
        Map<File, Integer> oldFileToId = this.fileToId.toMap();
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clean();
        this.fileToId.clean();
        this.size = 0;
        this.deletedCount = 0;
        Object $this$sortedBy$iv = oldFileToId.entrySet();
        boolean $i$f$sortedBy = false;
        $i$f$filterTo2 = false;
        Iterator<Object> iterator2 = kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((File)it.getKey()).getPath());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = ((File)it.getKey()).getPath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        }).iterator();
        while (iterator2.hasNext()) {
            void file2;
            Map.Entry $i$f$filterTo2 = $this$filter$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            $this$sortedBy$iv = (File)$i$f$filterTo2.getKey();
            $i$f$filterTo2 = $this$filter$iv;
            bl = false;
            int oldId = ((Number)$i$f$filterTo2.getValue()).intValue();
            int newId = this.addFileIfNeeded((File)file2);
            ((Map)oldIdToNewId).put(oldId, newId);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void $this$mapNotNullTo$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(lookup);
            Intrinsics.checkNotNull(collection);
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Integer n;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if ((Integer)oldIdToNewId.get(it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Integer it$iv$iv = n;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set fileIds = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    public final void forceGC() {
        this.removeGarbageIfNeeded(true);
        this.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(lookupSymbols, (String)"lookupSymbols");
        this.flush(false);
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer(sb);
        p.println("====== File to id map");
        p.println(this.fileToId.dump());
        p.println("====== Id to file map");
        p.println(this.idToFile.dump());
        Iterable $this$groupBy$iv = lookupSymbols;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LookupSymbol it = (LookupSymbol)element$iv$iv;
            boolean bl = false;
            LookupSymbolKey key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map lookupsStrings = destination$iv$iv;
        for (LookupSymbolKey lookup : kotlin.collections.CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void $this$mapTo$iv$iv;
            Collection<Integer> fileIds;
            String string2;
            String string3;
            Collection collection;
            Intrinsics.checkNotNull(this.lookupMap.get(lookup));
            Map $i$f$groupByTo2 = lookupsStrings;
            boolean bl = false;
            Object element$iv$iv = $i$f$groupByTo2;
            boolean list$iv$iv = false;
            if (element$iv$iv.containsKey(lookup)) {
                void $this$mapTo$iv$iv2;
                Object v = lookupsStrings.get(lookup);
                Intrinsics.checkNotNull(v);
                Iterable $this$map$iv = (Iterable)v;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    LookupSymbol $i$f$getOrPut = (LookupSymbol)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    string3 = it.getScope() + '#' + it.getName();
                    collection.add(string3);
                }
                string2 = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            } else {
                string2 = lookup.toString();
            }
            String key = string2;
            Iterable $this$map$iv = fileIds;
            boolean $i$f$map = false;
            Iterable destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int bl3 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv3;
                boolean bl4 = false;
                string3 = String.valueOf((int)it);
                collection.add(string3);
            }
            String value = kotlin.collections.CollectionsKt.joinToString$default((Iterable)kotlin.collections.CollectionsKt.sorted((Iterable)((List)destination$iv$iv3)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            p.println(key + " -> " + value);
        }
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sb.toString()");
        return string4;
    }

    public LookupStorage(@NotNull File targetDataDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkNotNullParameter((Object)targetDataDir, (String)"targetDataDir");
        Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
        super(targetDataDir);
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file"), pathConverter));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id"), pathConverter));
        this.lookupMap = (LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups")));
        try {
            if (this.countersFile.exists()) {
                List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1, null);
                String string2 = (String)lines.get(0);
                boolean bl = false;
                this.size = Integer.parseInt(string2);
                string2 = (String)lines.get(1);
                bl = false;
                this.deletedCount = Integer.parseInt(string2);
            }
        }
        catch (Exception e) {
            throw (Throwable)new IOException("Could not read " + this.countersFile, e);
        }
    }

    static {
        Companion = new Companion(null);
        DELETED_TO_SIZE_TRESHOLD = 0.5;
        MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    }

    public static final /* synthetic */ int access$addFileIfNeeded(LookupStorage $this, File file2) {
        return $this.addFileIfNeeded(file2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

