/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ExternalSystemTaskId id, @Nullable GradleExecutionSettings settings2, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (modelType == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        ModelBuilder result = connection.model(modelType);
        if (settings2 != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings2, listener2, connection);
        }
        ModelBuilder modelBuilder = result;
        if (modelBuilder == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        return modelBuilder;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ExternalSystemTaskId id, @NotNull ProjectConnection connection, @Nullable GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        BuildLauncher result = connection.newBuild();
        if (settings2 != null) {
            GradleExecutionHelper.prepare((LongRunningOperation)result, id, settings2, listener2, connection);
        }
        BuildLauncher buildLauncher = result;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        return buildLauncher;
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        return this.execute(projectPath, settings2, null, null, null, f);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        File projectPathFile;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if ((projectPathFile = new File(projectPath)).isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings2 != null && !(arguments = settings2.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings2.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return (T)GradleConnectorService.withGradleConnection(projectDir, taskId, settings2, listener2, cancellationToken, connection -> {
            String userDir = null;
            if (!GradleEnvironment.ADJUST_USER_DIR) {
                try {
                    userDir = System.getProperty("user.dir");
                    if (userDir != null) {
                        System.setProperty("user.dir", projectDir);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Object object = f.fun(connection);
                return object;
            }
            catch (ExternalSystemException e) {
                throw e;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
            finally {
                if (userDir != null) {
                    System.setProperty("user.dir", userDir);
                }
            }
        });
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        this.ensureInstalledWrapper(id, projectPath, settings2, null, listener2, cancellationToken);
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        if (!settings2.getDistributionType().isWrapped()) {
            return;
        }
        if (settings2.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        GradleConnectorService.withGradleConnection(projectPath, id, settings2, listener2, cancellationToken, connection -> {
            long ttlInMs = settings2.getRemoteProcessIdleTtlInMs();
            try {
                settings2.setRemoteProcessIdleTtlInMs(100L);
                try {
                    File wrapperFilesLocation = FileUtil.createTempDirectory((String)"wrap", (String)"loc");
                    String fileName = "gradle-wrapper";
                    File jarFile = new File(wrapperFilesLocation, "gradle-wrapper.jar");
                    File scriptFile = new File(wrapperFilesLocation, "gradlew");
                    File pathToProperties = new File(wrapperFilesLocation, "path.tmp");
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)wrapperFilesLocation), "GradleExecutionHelper cleanup"));
                    StringJoiner lines = new StringJoiner(SystemProperties.getLineSeparator());
                    lines.add("");
                    lines.add("gradle.projectsEvaluated { gr ->");
                    lines.add("  def wrapper = gr.rootProject.tasks[\"wrapper\"]");
                    lines.add("  if (wrapper != null) {");
                    lines.add("    if (wrapper.jarFile.exists()) {");
                    lines.add("      wrapper.jarFile = new File('" + StringUtil.escapeBackSlashes((String)jarFile.getCanonicalPath()) + "')");
                    lines.add("      wrapper.scriptFile = new File('" + StringUtil.escapeBackSlashes((String)scriptFile.getCanonicalPath()) + "')");
                    lines.add("    }");
                    if (gradleVersion != null) {
                        lines.add("    wrapper.gradleVersion = '" + gradleVersion.getVersion() + "'");
                    }
                    lines.add("    wrapper.doLast {");
                    lines.add("      new File('" + StringUtil.escapeBackSlashes((String)pathToProperties.getCanonicalPath()) + "').write wrapper.propertiesFile.getCanonicalPath()");
                    lines.add("    }");
                    lines.add("  }");
                    lines.add("}");
                    lines.add("");
                    File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(lines.toString(), "wrapper_init");
                    settings2.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
                    BuildLauncher launcher = this.getBuildLauncher(id, (ProjectConnection)connection, settings2, listener2);
                    launcher.withCancellationToken(cancellationToken);
                    launcher.forTasks(new String[]{"wrapper"});
                    launcher.run();
                    settings2.setWrapperPropertyFile(FileUtil.loadFile((File)pathToProperties));
                }
                catch (IOException e) {
                    LOG.warn("Can't update wrapper", (Throwable)e);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Can't update wrapper", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause));
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
            finally {
                settings2.setRemoteProcessIdleTtlInMs(ttlInMs);
            }
            return null;
        });
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(ProjectResolverContext projectResolverContext) {
        CancellationTokenSource cancellationTokenSource = projectResolverContext.getCancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(projectResolverContext.getConnection(), projectResolverContext.getExternalSystemTaskId(), projectResolverContext.getListener(), cancellationToken, projectResolverContext.getSettings());
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        GradleExecutionHelper.prepare(operation, id, settings2, listener2, connection, (OutputStream)new OutputWrapper(listener2, id, true), (OutputStream)new OutputWrapper(listener2, id, false));
    }

    public static void prepare(@NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull OutputStream standardOutput, @NotNull OutputStream standardError) {
        BuildIdentifier buildIdentifier;
        Application application;
        ArrayList<String> filteredArgs;
        String gradleVersion;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (standardOutput == null) {
            GradleExecutionHelper.$$$reportNull$$$0(33);
        }
        if (standardError == null) {
            GradleExecutionHelper.$$$reportNull$$$0(34);
        }
        List<String> jvmArgs = settings2.getJvmArguments();
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, (CancellationToken)null, settings2);
        String string = gradleVersion = buildEnvironment != null ? buildEnvironment.getGradle().getGradleVersion() : null;
        if (!jvmArgs.isEmpty()) {
            List<String> merged;
            if (buildEnvironment != null) {
                BuildIdentifier buildIdentifier2 = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
                List buildJvmArguments = buildIdentifier2 == null || "buildSrc".equals(buildIdentifier2.getRootDir().getName()) ? ContainerUtil.emptyList() : buildEnvironment.getJava().getJvmArguments();
                merged = GradleExecutionHelper.mergeJvmArgs(settings2.getServiceDirectory(), buildJvmArguments, jvmArgs);
            } else {
                merged = jvmArgs;
            }
            filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation.setJvmArguments(ArrayUtilRt.toStringArray((Collection)filteredArgs));
        }
        if (settings2.isOfflineWork()) {
            settings2.withArgument("--offline");
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode() && !settings2.getArguments().contains("--quiet") && !settings2.getArguments().contains("--debug")) {
            settings2.withArgument("--info");
        }
        filteredArgs = new ArrayList<String>();
        if (!settings2.getArguments().isEmpty()) {
            String loggableArgs = StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(settings2.getArguments()), (String)" ");
            LOG.info("Passing command-line args to Gradle Tooling API: " + loggableArgs);
            filteredArgs.addAll(ContainerUtil.mapNotNull((Collection)settings2.getArguments(), s -> StringUtil.isEmpty((String)s) ? null : s));
            GradleExecutionHelper.replaceTestCommandOptionWithInitScript(filteredArgs);
        }
        filteredArgs.add("-Didea.active=true");
        filteredArgs.add("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        operation.withArguments(ArrayUtilRt.toStringArray(filteredArgs));
        GradleExecutionHelper.setupEnvironment(operation, settings2, gradleVersion, id, listener2);
        String javaHome = settings2.getJavaHome();
        if (javaHome != null && new File(javaHome).isDirectory()) {
            LOG.debug("Java home to set for Gradle operation: " + javaHome);
            operation.setJavaHome(new File(javaHome));
        }
        String buildRootDir = buildEnvironment == null ? null : ((buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment)) == null ? null : buildIdentifier.getRootDir().getPath());
        GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
        operation.addProgressListener((ProgressListener)gradleProgressListener, new OperationType[]{OperationType.TASK, OperationType.TEST});
        operation.setStandardOutput(standardOutput);
        operation.setStandardError(standardError);
        InputStream inputStream = (InputStream)settings2.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    @Nullable
    private static BuildIdentifier getBuildIdentifier(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(35);
        }
        try {
            return buildEnvironment.getBuildIdentifier();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return null;
        }
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2, @Nullable String gradleVersion, ExternalSystemTaskId taskId, ExternalSystemTaskNotificationListener listener2) {
        boolean isEnvironmentCustomizationSupported;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(36);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(37);
        }
        boolean bl = isEnvironmentCustomizationSupported = gradleVersion != null && GradleVersion.version((String)gradleVersion).getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0;
        if (!isEnvironmentCustomizationSupported) {
            if (!settings2.isPassParentEnvs() || !settings2.getEnv().isEmpty()) {
                listener2.onTaskOutput(taskId, String.format("The version of Gradle you are using%s does not support the environment variables customization feature. Support for this is available in Gradle 3.5 and all later versions.\n", gradleVersion == null ? "" : " (" + gradleVersion + ")"), false);
            }
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings2.getEnv());
        commandLine.withParentEnvironmentType(settings2.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    @ApiStatus.Experimental
    static List<String> mergeJvmArgs(String serviceDirectory, List<String> jvmArgs, List<String> jvmArgsFromIdeSettings) {
        File gradleUserHomeDir = serviceDirectory != null ? new File(serviceDirectory) : new BuildLayoutParameters().getGradleUserHomeDir();
        LOG.debug("Gradle home: " + gradleUserHomeDir);
        NativeServices.initialize((File)gradleUserHomeDir);
        JvmOptions jvmOptions = new JvmOptions(null);
        List<String> mergedJvmArgs = GradleExecutionHelper.mergeJvmArgs(jvmArgs, jvmArgsFromIdeSettings);
        jvmOptions.setAllJvmArgs(mergedJvmArgs);
        return jvmOptions.getAllJvmArgs();
    }

    @ApiStatus.Experimental
    static List<String> mergeJvmArgs(List<String> jvmArgs, List<String> jvmArgsFromIdeSettings) {
        MultiMap argumentsMap = MultiMap.createLinkedSet();
        String lastKey = null;
        for (String jvmArg : ContainerUtil.concat(jvmArgs, jvmArgsFromIdeSettings)) {
            if (jvmArg.startsWith("-")) {
                argumentsMap.putValue((Object)jvmArg, (Object)"");
                lastKey = jvmArg;
                continue;
            }
            if (lastKey != null) {
                argumentsMap.putValue((Object)lastKey, (Object)jvmArg);
                lastKey = null;
                continue;
            }
            argumentsMap.putValue((Object)jvmArg, (Object)"");
        }
        LinkedHashMap<String, String> mergedKeys = new LinkedHashMap<String, String>();
        LinkedHashSet argKeySet = new LinkedHashSet(argumentsMap.keySet());
        for (String argKey : argKeySet) {
            Collection values = argumentsMap.getModifiable((Object)argKey);
            if (values.size() == 1 && ((String)values.iterator().next()).isEmpty()) {
                Couple<String> couple = GradleExecutionHelper.splitArg(argKey);
                mergedKeys.put((String)couple.first, (String)couple.second);
                continue;
            }
            mergedKeys.put(argKey, "");
            LinkedHashMap<String, String> mergedArgs = new LinkedHashMap<String, String>();
            for (String jvmArg : values) {
                if (jvmArg.isEmpty()) continue;
                Couple<String> couple = GradleExecutionHelper.splitArg(jvmArg);
                mergedArgs.put((String)couple.first, (String)couple.second);
            }
            values.clear();
            mergedArgs.forEach((key, value) -> values.add(key + value));
        }
        SmartList mergedArgs = new SmartList();
        mergedKeys.forEach((arg_0, arg_1) -> GradleExecutionHelper.lambda$mergeJvmArgs$6((List)mergedArgs, arg_0, arg_1));
        argKeySet.stream().filter(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$7((List)mergedArgs, arg_0)).forEach(arg_0 -> ((MultiMap)argumentsMap).remove(arg_0));
        argumentsMap.remove((Object)"--add-opens");
        SmartList result = new SmartList();
        argumentsMap.keySet().forEach(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$9(argumentsMap, (List)result, arg_0));
        return result;
    }

    private static Couple<String> splitArg(String arg) {
        int i2 = arg.indexOf(61);
        return i2 <= 0 ? Couple.of((Object)arg, (Object)"") : Couple.of((Object)arg.substring(0, i2), (Object)arg.substring(i2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static File generateInitScript(boolean isBuildSrcProject, @NotNull Set<Class<?>> toolingExtensionClasses) {
        InputStream stream;
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(38);
        }
        if ((stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/init.gradle")) == null) {
            LOG.warn("Can't find init script template");
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            String toolingExtensionsJarPaths = GradleExecutionHelper.getToolingExtensionsJarPaths(toolingExtensionClasses);
            Object script = StreamUtil.readText((Reader)reader).replaceFirst(Pattern.quote("${EXTENSIONS_JARS_PATH}"), toolingExtensionsJarPaths);
            if (isBuildSrcProject) {
                String buildSrcDefaultInitScript = GradleExecutionHelper.getBuildSrcDefaultInitScript();
                if (buildSrcDefaultInitScript == null) {
                    File file = null;
                    return file;
                }
                script = (String)script + buildSrcDefaultInitScript;
            }
            File file = GradleExecutionHelper.writeToFileGradleInitScript((String)script, "ijinit");
            return file;
        }
        catch (Exception e) {
            LOG.warn("Can't generate IJ gradle init script", (Throwable)e);
            return null;
        }
    }

    public static File writeToFileGradleInitScript(@NotNull String content, @NotNull String filePrefix) throws IOException {
        if (content == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (filePrefix == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        int contentLength = contentBytes.length;
        return FileUtil.findSequentFile((File)new File(FileUtil.getTempDirectory()), (String)filePrefix, (String)"gradle", file -> {
            try {
                if (!file.exists()) {
                    FileUtil.writeToFile((File)file, (byte[])contentBytes, (boolean)false);
                    file.deleteOnExit();
                    return true;
                }
                if ((long)contentLength != file.length()) {
                    return false;
                }
                return content.equals(FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                return false;
            }
        });
    }

    @Nullable
    public static String getBuildSrcDefaultInitScript() {
        String string;
        InputStream stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/buildSrcInit.gradle");
        if (stream == null) {
            LOG.warn("Can't find default init script template");
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            string = StreamUtil.readText((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Can't use IJ gradle init script", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return string;
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationTokenSource, null);
        GradleVersion gradleVersion = null;
        if (buildEnvironment != null) {
            gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @Nullable GradleExecutionSettings settings2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationToken, settings2);
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @Nullable GradleExecutionSettings settings2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        BuildEnvironment buildEnvironment = null;
        try {
            String javaHome;
            ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
            if (cancellationToken != null) {
                modelBuilder.withCancellationToken(cancellationToken);
            }
            if (settings2 != null && (javaHome = settings2.getJavaHome()) != null && new File(javaHome).isDirectory()) {
                modelBuilder.setJavaHome(new File(javaHome));
            }
            GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId);
            modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
            modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
            modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
            modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
            buildEnvironment = (BuildEnvironment)modelBuilder.get();
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug("Gradle version: " + buildEnvironment.getGradle().getGradleVersion());
                    LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                    LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
                }
                catch (Throwable t) {
                    LOG.debug(t);
                }
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
        return buildEnvironment;
    }

    private static void replaceTestCommandOptionWithInitScript(@NotNull List<String> args) {
        if (args == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        LinkedHashSet<String> testIncludePatterns = new LinkedHashSet<String>();
        Iterator<String> it = args.iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (!"--tests".equals(next)) continue;
            it.remove();
            if (!it.hasNext()) continue;
            testIncludePatterns.add(it.next());
            it.remove();
        }
        if (!testIncludePatterns.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append('[');
            Iterator iterator = testIncludePatterns.iterator();
            while (iterator.hasNext()) {
                String pattern = (String)iterator.next();
                String groovyPattern = GradleExecutionHelper.toGroovyString(pattern);
                buf.append('\'').append(groovyPattern).append('\'');
                if (!iterator.hasNext()) continue;
                buf.append(',');
            }
            buf.append(']');
            String path = GradleExecutionHelper.renderInitScript(buf.toString());
            if (path != null) {
                ContainerUtil.addAll(args, (Object[])new String[]{"--init-script", path});
            }
        }
    }

    @NotNull
    public static String toGroovyString(@NotNull String string) {
        if (string == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char ch : string.toCharArray()) {
            if (ch == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (ch == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (ch == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(ch);
        }
        String string2 = stringBuilder.toString();
        if (string2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        return string2;
    }

    @Nullable
    public static String renderInitScript(@NotNull String testArgs) {
        String string;
        InputStream stream;
        if (testArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(53);
        }
        if ((stream = Init.class.getResourceAsStream("/org/jetbrains/plugins/gradle/tooling/internal/init/testFilterInit.gradle")) == null) {
            LOG.error("Can't find test filter init script template");
            return null;
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            String script = StreamUtil.readText((Reader)reader).replaceFirst(Pattern.quote("${TEST_NAME_INCLUDES}"), Matcher.quoteReplacement(testArgs));
            File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(script, "ijtestinit");
            string = tempFile.getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Can't generate IJ gradle test filter init script", (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return string;
    }

    @NotNull
    public static String getToolingExtensionsJarPaths(@NotNull Set<Class<?>> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(54);
        }
        Set jarPaths = ContainerUtil.map2SetNotNull(toolingExtensionClasses, aClass -> {
            String path = PathManager.getJarPathForClass((Class)aClass);
            if (path != null) {
                if (FileUtilRt.getNameWithoutExtension((String)path).equals("gradle-api-" + GradleVersion.current().getBaseVersion())) {
                    LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
                    return null;
                }
                return FileUtil.toCanonicalPath((String)path);
            }
            return null;
        });
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Iterator it = jarPaths.iterator();
        while (it.hasNext()) {
            String jarPath = (String)it.next();
            buf.append('\"').append(jarPath).append('\"');
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        String string = buf.toString();
        if (string == null) {
            GradleExecutionHelper.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(56);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$9(MultiMap argumentsMap, List result, String key) {
        argumentsMap.get((Object)key).forEach(val -> {
            result.add(key);
            if (StringUtil.isNotEmpty((String)val)) {
                result.add(val);
            }
        });
    }

    private static /* synthetic */ boolean lambda$mergeJvmArgs$7(List mergedArgs, String argKey) {
        return !mergedArgs.contains(argKey);
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$6(List mergedArgs, String s1, String s2) {
        mergedArgs.add(s1 + s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 52: 
            case 55: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 52: 
            case 55: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelType";
                break;
            }
            case 1: 
            case 5: 
            case 13: 
            case 18: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 6: 
            case 27: 
            case 32: 
            case 41: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 21: 
            case 26: 
            case 31: 
            case 43: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 8: 
            case 52: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 15: 
            case 20: 
            case 25: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 23: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardOutput";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardError";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArgs";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "toGroovyString";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsJarPaths";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilder";
                break;
            }
            case 4: 
            case 8: 
            case 52: 
            case 55: 
            case 57: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureInstalledWrapper";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getBuildIdentifier";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateInitScript";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "writeToFileGradleInitScript";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "replaceTestCommandOptionWithInitScript";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "toGroovyString";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "renderInitScript";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getToolingExtensionsJarPaths";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 52: 
            case 55: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

