/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.PreResolvedResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalDependencyFiles;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AbstractTransformedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class LocalFileDependencyBackedArtifactSet
implements ResolvedArtifactSet,
LocalDependencyFiles,
VariantSelector.Factory {
    private static final DisplayName LOCAL_FILE = Describables.of("local file");
    private final LocalFileDependencyMetadata dependencyMetadata;
    private final Spec<? super ComponentIdentifier> componentFilter;
    private final VariantSelector selector;
    private final ArtifactTypeRegistry artifactTypeRegistry;

    public LocalFileDependencyBackedArtifactSet(LocalFileDependencyMetadata dependencyMetadata, Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector, ArtifactTypeRegistry artifactTypeRegistry) {
        this.dependencyMetadata = dependencyMetadata;
        this.componentFilter = componentFilter;
        this.selector = selector;
        this.artifactTypeRegistry = artifactTypeRegistry;
    }

    @Override
    public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
        Set<File> files2;
        FileCollectionStructureVisitor.VisitType visitType = listener.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            return EMPTY_RESULT;
        }
        ComponentIdentifier componentIdentifier = this.dependencyMetadata.getComponentId();
        if (componentIdentifier != null && !this.componentFilter.isSatisfiedBy(componentIdentifier)) {
            return EMPTY_RESULT;
        }
        FileCollectionInternal fileCollection = this.dependencyMetadata.getFiles();
        try {
            files2 = fileCollection.getFiles();
        }
        catch (Exception throwable) {
            return new BrokenResolvedArtifactSet(throwable);
        }
        ImmutableList.Builder selectedArtifacts = ImmutableList.builderWithExpectedSize((int)files2.size());
        for (File file : files2) {
            DisplayName artifactIdentifier;
            if (componentIdentifier == null) {
                artifactIdentifier = new OpaqueComponentArtifactIdentifier(file);
                if (!this.componentFilter.isSatisfiedBy(artifactIdentifier.getComponentIdentifier())) {
                    continue;
                }
            } else {
                artifactIdentifier = new ComponentFileArtifactIdentifier(componentIdentifier, file.getName());
            }
            ImmutableAttributes variantAttributes = this.artifactTypeRegistry.mapAttributesFor(file);
            SingletonFileResolvedVariant variant = new SingletonFileResolvedVariant(file, (ComponentArtifactIdentifier)((Object)artifactIdentifier), LOCAL_FILE, variantAttributes, this.dependencyMetadata);
            selectedArtifacts.add((Object)this.selector.select(variant, this));
        }
        ResolvedArtifactSet.Completion result = CompositeResolvedArtifactSet.of((Collection<? extends ResolvedArtifactSet>)selectedArtifacts.build()).startVisit(actions, listener);
        if (visitType == FileCollectionStructureVisitor.VisitType.Spec) {
            return visitor -> {
                result.visit(visitor);
                visitor.visitSpec(fileCollection);
            };
        }
        return result;
    }

    @Override
    public ResolvedArtifactSet asTransformed(ResolvedVariant sourceVariant, ImmutableAttributes targetAttributes, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver, TransformedVariantFactory transformedVariantFactory) {
        return new TransformedLocalFileArtifactSet((SingletonFileResolvedVariant)sourceVariant, targetAttributes, transformation, dependenciesResolver, TransformationNodeRegistry.EMPTY);
    }

    @Override
    public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor visitor) {
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.dependencyMetadata.getFiles().getBuildDependencies());
    }

    public static class TransformedLocalFileArtifactSet
    extends AbstractTransformedArtifactSet
    implements FileCollectionInternal.Source {
        private final SingletonFileResolvedVariant delegate;
        private final Transformation transformation;

        public TransformedLocalFileArtifactSet(SingletonFileResolvedVariant delegate, ImmutableAttributes attributes, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver, TransformationNodeRegistry transformationNodeRegistry) {
            super(delegate.getComponentId(), delegate, attributes, transformation, dependenciesResolver, transformationNodeRegistry);
            this.delegate = delegate;
            this.transformation = transformation;
        }

        public ComponentIdentifier getOwnerId() {
            return this.delegate.getComponentId();
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public Transformation getTransformation() {
            return this.transformation;
        }

        public DisplayName getTargetVariantName() {
            return this.delegate.variantName;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            throw new IllegalStateException();
        }
    }

    private static class SingletonFileResolvedVariant
    implements ResolvedVariant,
    ResolvedArtifactSet,
    ResolvedArtifactSet.Completion,
    ResolvedVariantSet {
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final DisplayName variantName;
        private final ImmutableAttributes variantAttributes;
        private final LocalFileDependencyMetadata dependencyMetadata;
        private final ResolvableArtifact artifact;

        SingletonFileResolvedVariant(File file, ComponentArtifactIdentifier artifactIdentifier, DisplayName variantName, ImmutableAttributes variantAttributes, LocalFileDependencyMetadata dependencyMetadata) {
            this.artifactIdentifier = artifactIdentifier;
            this.variantName = variantName;
            this.variantAttributes = variantAttributes;
            this.dependencyMetadata = dependencyMetadata;
            this.artifact = new PreResolvedResolvableArtifact(null, DefaultIvyArtifactName.forFile(file, null), this.artifactIdentifier, file, this.dependencyMetadata.getFiles());
        }

        @Override
        public VariantResolveMetadata.Identifier getIdentifier() {
            return null;
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        public File getFile() {
            return this.artifact.getFile();
        }

        public ComponentIdentifier getComponentId() {
            return this.artifactIdentifier.getComponentIdentifier();
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this;
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of(this.artifactIdentifier);
        }

        @Override
        public Set<ResolvedVariant> getVariants() {
            return Collections.singleton(this);
        }

        @Override
        public ImmutableAttributes getOverriddenAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public AttributesSchemaInternal getSchema() {
            return EmptySchema.INSTANCE;
        }

        @Override
        public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
            listener.artifactAvailable(this.artifact);
            return this;
        }

        @Override
        public void visitLocalArtifacts(ResolvedArtifactSet.LocalArtifactVisitor visitor) {
        }

        @Override
        public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            visitor.visitArtifact(this.variantName, this.variantAttributes, this.artifact);
            visitor.endVisitCollection(FileCollectionInternal.OTHER);
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.dependencyMetadata.getFiles().getBuildDependencies());
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return this.variantAttributes;
        }
    }
}

