/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public class Collectors {

    public static class TypedCollector<T>
    implements ProvidedCollector<T> {
        private final Class<? extends T> type;
        protected final Collector<T> delegate;
        private final ValueCollector<T> valueCollector;

        public TypedCollector(@Nullable Class<? extends T> type, Collector<T> delegate) {
            this.type = type;
            this.delegate = delegate;
            this.valueCollector = ValueSanitizers.collectorFor(type);
        }

        @Nullable
        public Class<? extends T> getType() {
            return this.type;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.delegate.calculatePresence(consumer);
        }

        public void collectInto(ImmutableCollection.Builder<T> builder) {
            this.collectEntries(ValueSupplier.ValueConsumer.IgnoreUnsafeRead, this.valueCollector, builder);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            return this.delegate.collectEntries(consumer, collector, dest);
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return this.delegate instanceof ProvidedCollector && ((ProvidedCollector)this.delegate).isProvidedBy(provider);
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            this.delegate.calculateExecutionTimeValue(visitor);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.delegate.getProducer();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedCollector that = (TypedCollector)o;
            return Objects.equal(this.type, that.type) && Objects.equal(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.delegate});
        }
    }

    public static class ElementsFromArray<T>
    implements Collector<T> {
        private final T[] value;

        ElementsFromArray(T[] value) {
            this.value = value;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            for (T t : this.value) {
                collector.add(t, dest);
            }
            return ValueSupplier.Value.present();
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            visitor.execute(ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableList.copyOf((Object[])this.value)));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        @Override
        public int size() {
            return this.value.length;
        }
    }

    public static class ElementsFromCollectionProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends Iterable<? extends T>> provider;

        public ElementsFromCollectionProvider(ProviderInternal<? extends Iterable<? extends T>> provider) {
            this.provider = provider;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.provider.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection2) {
            ValueSupplier.Value<Iterable<T>> value = this.provider.calculateValue(consumer);
            if (value.isMissing()) {
                return value.asType();
            }
            collector.addAll(value.get(), collection2);
            return ValueSupplier.Value.present();
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            visitor.execute(this.provider.calculateExecutionTimeValue());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.provider.getProducer();
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, provider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollectionProvider that = (ElementsFromCollectionProvider)o;
            return Objects.equal(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.provider});
        }

        @Override
        public int size() {
            if (this.provider instanceof CollectionProviderInternal) {
                return ((CollectionProviderInternal)this.provider).size();
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class ElementsFromCollection<T>
    implements Collector<T> {
        private final Iterable<? extends T> value;

        public ElementsFromCollection(Iterable<? extends T> value) {
            this.value = value;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection2) {
            collector.addAll(this.value, collection2);
            return ValueSupplier.Value.present();
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            visitor.execute(ValueSupplier.ExecutionTimeValue.fixedValue(this.value));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementsFromCollection that = (ElementsFromCollection)o;
            return Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }

        @Override
        public int size() {
            return Iterables.size(this.value);
        }
    }

    public static class ElementFromProvider<T>
    implements ProvidedCollector<T> {
        private final ProviderInternal<? extends T> provider;

        public ElementFromProvider(ProviderInternal<? extends T> provider) {
            this.provider = provider;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.provider.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection2) {
            ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
            if (value.isMissing()) {
                return value.asType();
            }
            collector.add(value.get(), collection2);
            return ValueSupplier.Value.present();
        }

        @Override
        public boolean isProvidedBy(Provider<?> provider) {
            return Objects.equal(provider, this.provider);
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            ValueSupplier.ExecutionTimeValue<T> value = this.provider.calculateExecutionTimeValue();
            if (value.isMissing()) {
                visitor.execute(ValueSupplier.ExecutionTimeValue.missing());
            } else if (value.isFixedValue()) {
                visitor.execute(ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableList.of(value.getFixedValue())));
            } else {
                visitor.execute(ValueSupplier.ExecutionTimeValue.changingValue(value.getChangingValue().map(e -> ImmutableList.of((Object)e))));
            }
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.provider.getProducer();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementFromProvider that = (ElementFromProvider)o;
            return Objects.equal(this.provider, that.provider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.provider});
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class SingleElement<T>
    implements Collector<T> {
        private final T element;

        public SingleElement(T element) {
            this.element = element;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> collection2) {
            collector.add(this.element, collection2);
            return ValueSupplier.Value.present();
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            visitor.execute(ValueSupplier.ExecutionTimeValue.fixedValue(ImmutableList.of(this.element)));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleElement that = (SingleElement)o;
            return Objects.equal(this.element, that.element);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.element});
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static interface ProvidedCollector<T>
    extends Collector<T> {
        public boolean isProvidedBy(Provider<?> var1);
    }
}

