/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSets;

public class ClassAnalysis {
    private final String className;
    private final Set<String> privateClassDependencies;
    private final Set<String> accessibleClassDependencies;
    private final boolean dependencyToAll;
    private final IntSet constants;

    public ClassAnalysis(String className, Set<String> privateClassDependencies, Set<String> accessibleClassDependencies, boolean dependencyToAll, IntSet constants) {
        this.className = className;
        this.privateClassDependencies = ImmutableSet.copyOf(privateClassDependencies);
        this.accessibleClassDependencies = ImmutableSet.copyOf(accessibleClassDependencies);
        this.dependencyToAll = dependencyToAll;
        this.constants = constants.isEmpty() ? IntSets.EMPTY_SET : constants;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getPrivateClassDependencies() {
        return this.privateClassDependencies;
    }

    public Set<String> getAccessibleClassDependencies() {
        return this.accessibleClassDependencies;
    }

    public IntSet getConstants() {
        return this.constants;
    }

    public boolean isDependencyToAll() {
        return this.dependencyToAll;
    }
}

