/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.project.taskfactory.IncrementalInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskInputsTaskAction;
import org.gradle.api.internal.tasks.DefaultTaskValidationContext;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationResult;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.EmptySourceTaskSkipper;
import org.gradle.api.internal.tasks.execution.ExecuteTaskActionBuildOperationType;
import org.gradle.api.internal.tasks.execution.TaskCacheabilityResolver;
import org.gradle.api.internal.tasks.execution.TaskSnapshotter;
import org.gradle.api.internal.tasks.properties.CacheableOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.TaskProperties;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.ExecutionRequestContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.impl.OutputFilterUtil;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.overlap.OverlappingOutputs;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.work.AsyncWorkTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteActionsTaskExecuter.class);
    private final BuildCacheState buildCacheState;
    private final ScanPluginState scanPluginState;
    private final TaskSnapshotter taskSnapshotter;
    private final ExecutionHistoryStore executionHistoryStore;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final TaskActionListener actionListener;
    private final TaskCacheabilityResolver taskCacheabilityResolver;
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final WorkExecutor<ExecutionRequestContext, CachingResult> workExecutor;
    private final ListenerManager listenerManager;
    private final ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry;
    private final EmptySourceTaskSkipper emptySourceTaskSkipper;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileOperations fileOperations;

    public ExecuteActionsTaskExecuter(BuildCacheState buildCacheState, ScanPluginState scanPluginState, TaskSnapshotter taskSnapshotter, ExecutionHistoryStore executionHistoryStore, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, TaskActionListener actionListener, TaskCacheabilityResolver taskCacheabilityResolver, FileCollectionFingerprinterRegistry fingerprinterRegistry, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, WorkExecutor<ExecutionRequestContext, CachingResult> workExecutor, ListenerManager listenerManager, ReservedFileSystemLocationRegistry reservedFileSystemLocationRegistry, EmptySourceTaskSkipper emptySourceTaskSkipper, FileCollectionFactory fileCollectionFactory, FileOperations fileOperations) {
        this.buildCacheState = buildCacheState;
        this.scanPluginState = scanPluginState;
        this.taskSnapshotter = taskSnapshotter;
        this.executionHistoryStore = executionHistoryStore;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.actionListener = actionListener;
        this.taskCacheabilityResolver = taskCacheabilityResolver;
        this.fingerprinterRegistry = fingerprinterRegistry;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.workExecutor = workExecutor;
        this.listenerManager = listenerManager;
        this.reservedFileSystemLocationRegistry = reservedFileSystemLocationRegistry;
        this.emptySourceTaskSkipper = emptySourceTaskSkipper;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileOperations = fileOperations;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state2, TaskExecutionContext context) {
        TaskExecution work = new TaskExecution(task, context, this.executionHistoryStore, this.fingerprinterRegistry, this.classLoaderHierarchyHasher);
        try {
            return this.executeIfValid(task, state2, context, work);
        }
        catch (WorkValidationException ex) {
            state2.setOutcome(ex);
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
    }

    private TaskExecuterResult executeIfValid(TaskInternal task, TaskStateInternal state2, final TaskExecutionContext context, final TaskExecution work) {
        final CachingResult result = this.workExecutor.execute(new ExecutionRequestContext(){

            @Override
            public UnitOfWork getWork() {
                return work;
            }

            @Override
            public Optional<String> getRebuildReason() {
                return context.getTaskExecutionMode().getRebuildReason();
            }
        });
        result.getOutcome().ifSuccessfulOrElse(outcome -> state2.setOutcome(TaskExecutionOutcome.valueOf(outcome)), failure -> state2.setOutcome(new TaskExecutionException(task, (Throwable)failure)));
        return new TaskExecuterResult(){

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.getReusedOutputOriginMetadata();
            }

            @Override
            public boolean executedIncrementally() {
                return result.getOutcome().map(executionOutcome -> executionOutcome == ExecutionOutcome.EXECUTED_INCREMENTALLY).getOrMapFailure(throwable -> false);
            }

            @Override
            public List<String> getExecutionReasons() {
                return result.getExecutionReasons();
            }

            @Override
            public CachingState getCachingState() {
                return result.getCachingState();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActions(TaskInternal task, @Nullable InputChangesInternal inputChanges) {
        boolean hasTaskListener = this.listenerManager.hasListeners(TaskActionListener.class) || this.listenerManager.hasListeners(TaskExecutionListener.class);
        Iterator<InputChangesAwareTaskAction> actions = new ArrayList<InputChangesAwareTaskAction>(task.getTaskActions()).iterator();
        while (actions.hasNext()) {
            InputChangesAwareTaskAction action = actions.next();
            task.getState().setDidWork(true);
            task.getStandardOutputCapture().start();
            boolean hasMoreWork = hasTaskListener || actions.hasNext();
            try {
                this.executeAction(action.getDisplayName(), task, action, inputChanges, hasMoreWork);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", (Object)e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", (Object)e.getMessage());
                break;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
    }

    private void executeAction(final String actionDisplayName, final TaskInternal task, final InputChangesAwareTaskAction action, @Nullable InputChangesInternal inputChanges, final boolean hasMoreWork) {
        if (inputChanges != null) {
            action.setInputChanges(inputChanges);
        }
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(actionDisplayName + " for " + task.getIdentityPath().getPath()).name(actionDisplayName).details(ExecuteTaskActionBuildOperationType.DETAILS_INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(BuildOperationContext context) {
                try {
                    BuildOperationRef currentOperation = ExecuteActionsTaskExecuter.this.buildOperationExecutor.getCurrentOperation();
                    Throwable actionFailure = null;
                    try {
                        action.execute(task);
                    }
                    catch (Throwable t) {
                        actionFailure = t;
                    }
                    finally {
                        action.clearInputChanges();
                    }
                    try {
                        ExecuteActionsTaskExecuter.this.asyncWorkTracker.waitForCompletion(currentOperation, hasMoreWork ? AsyncWorkTracker.ProjectLockRetention.RELEASE_AND_REACQUIRE_PROJECT_LOCKS : AsyncWorkTracker.ProjectLockRetention.RELEASE_PROJECT_LOCKS);
                    }
                    catch (Throwable t) {
                        ArrayList failures = Lists.newArrayList();
                        if (actionFailure != null) {
                            failures.add(actionFailure);
                        }
                        if (t instanceof MultiCauseException) {
                            failures.addAll(((MultiCauseException)((Object)t)).getCauses());
                        } else {
                            failures.add(t);
                        }
                        if (failures.size() > 1) {
                            throw new MultipleTaskActionFailures("Multiple task action failures occurred:", (Iterable<? extends Throwable>)failures);
                        }
                        throw UncheckedException.throwAsUncheckedException((Throwable)failures.get(0));
                    }
                    if (actionFailure != null) {
                        context.failed(actionFailure);
                        throw UncheckedException.throwAsUncheckedException(actionFailure);
                    }
                }
                finally {
                    context.setResult(ExecuteTaskActionBuildOperationType.RESULT_INSTANCE);
                }
            }
        });
    }

    private class PreviousOutputFileCollection
    extends LazilyInitializedFileCollection {
        private final TaskInternal task;
        private final AfterPreviousExecutionState previousExecution;

        public PreviousOutputFileCollection(TaskInternal task, AfterPreviousExecutionState previousExecution) {
            this.task = task;
            this.previousExecution = previousExecution;
        }

        @Override
        public FileCollectionInternal createDelegate() {
            ImmutableCollection outputFingerprints = this.previousExecution.getOutputFileProperties().values();
            HashSet<File> outputs = new HashSet<File>();
            for (FileCollectionFingerprint fileCollectionFingerprint : outputFingerprints) {
                for (String absolutePath : fileCollectionFingerprint.getFingerprints().keySet()) {
                    outputs.add(new File(absolutePath));
                }
            }
            return ExecuteActionsTaskExecuter.this.fileCollectionFactory.fixed(outputs);
        }

        @Override
        public String getDisplayName() {
            return "previous output files of " + this.task.toString();
        }
    }

    @Contextual
    private static class MultipleTaskActionFailures
    extends DefaultMultiCauseException {
        public MultipleTaskActionFailures(String message2, Iterable<? extends Throwable> causes) {
            super(message2, causes);
        }
    }

    private class TaskExecution
    implements UnitOfWork {
        private final TaskInternal task;
        private final TaskExecutionContext context;
        private final ExecutionHistoryStore executionHistoryStore;
        private final FileCollectionFingerprinterRegistry fingerprinterRegistry;
        private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;

        public TaskExecution(TaskInternal task, TaskExecutionContext context, ExecutionHistoryStore executionHistoryStore, FileCollectionFingerprinterRegistry fingerprinterRegistry, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
            this.task = task;
            this.context = context;
            this.executionHistoryStore = executionHistoryStore;
            this.fingerprinterRegistry = fingerprinterRegistry;
            this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        }

        @Override
        public String getIdentity() {
            return this.task.getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UnitOfWork.WorkResult execute(@Nullable InputChangesInternal inputChanges, InputChangesContext context) {
            FileCollection previousFiles = context.getAfterPreviousExecutionState().map(afterPreviousExecutionState -> new PreviousOutputFileCollection(this.task, (AfterPreviousExecutionState)afterPreviousExecutionState)).orElseGet(ExecuteActionsTaskExecuter.this.fileCollectionFactory::empty);
            TaskOutputsInternal outputs = this.task.getOutputs();
            outputs.setPreviousOutputFiles(previousFiles);
            try {
                UnitOfWork.WorkResult workResult = this.executeWithPreviousOutputFiles(inputChanges);
                return workResult;
            }
            finally {
                outputs.setPreviousOutputFiles(null);
            }
        }

        private UnitOfWork.WorkResult executeWithPreviousOutputFiles(@Nullable InputChangesInternal inputChanges) {
            this.task.getState().setExecuting(true);
            try {
                LOGGER.debug("Executing actions for {}.", (Object)this.task);
                ExecuteActionsTaskExecuter.this.actionListener.beforeActions(this.task);
                ExecuteActionsTaskExecuter.this.executeActions(this.task, inputChanges);
                UnitOfWork.WorkResult workResult = this.task.getState().getDidWork() ? UnitOfWork.WorkResult.DID_WORK : UnitOfWork.WorkResult.DID_NO_WORK;
                return workResult;
            }
            finally {
                this.task.getState().setExecuting(false);
                ExecuteActionsTaskExecuter.this.actionListener.afterActions(this.task);
            }
        }

        @Override
        public Optional<ExecutionHistoryStore> getExecutionHistoryStore() {
            return this.context.getTaskExecutionMode().isTaskHistoryMaintained() ? Optional.of(this.executionHistoryStore) : Optional.empty();
        }

        @Override
        public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
            visitor.visitImplementation(this.task.getClass());
            List<InputChangesAwareTaskAction> taskActions = this.task.getTaskActions();
            for (InputChangesAwareTaskAction taskAction : taskActions) {
                visitor.visitAdditionalImplementation(taskAction.getActionImplementation(this.classLoaderHierarchyHasher));
            }
        }

        @Override
        public void visitInputProperties(UnitOfWork.InputPropertyVisitor visitor) {
            Map<String, Object> inputPropertyValues = this.context.getTaskProperties().getInputPropertyValues().get();
            for (Map.Entry<String, Object> entry : inputPropertyValues.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                visitor.visitInputProperty(propertyName, value);
            }
        }

        @Override
        public void visitInputFileProperties(UnitOfWork.InputFilePropertyVisitor visitor) {
            ImmutableSortedSet<InputFilePropertySpec> inputFileProperties = this.context.getTaskProperties().getInputFileProperties();
            for (InputFilePropertySpec inputFileProperty : inputFileProperties) {
                Object value = inputFileProperty.getValue();
                boolean incremental = inputFileProperty.isIncremental() || inputFileProperty.isSkipWhenEmpty();
                String propertyName = inputFileProperty.getPropertyName();
                visitor.visitInputFileProperty(propertyName, value, incremental, () -> {
                    FileCollectionFingerprinter fingerprinter = this.fingerprinterRegistry.getFingerprinter(inputFileProperty.getNormalizer());
                    return fingerprinter.fingerprint(inputFileProperty.getPropertyFiles());
                });
            }
        }

        @Override
        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                File outputFile = property.getOutputFile();
                if (outputFile == null) continue;
                visitor.visitOutputProperty(property.getPropertyName(), property.getOutputType(), outputFile);
            }
        }

        @Override
        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            for (OutputFilePropertySpec property : this.context.getTaskProperties().getOutputFileProperties()) {
                if (!(property instanceof CacheableOutputFilePropertySpec)) {
                    throw new IllegalStateException("Non-cacheable property: " + property);
                }
                File cacheRoot = property.getOutputFile();
                if (cacheRoot == null) continue;
                visitor.visitOutputTree(property.getPropertyName(), property.getOutputType(), cacheRoot);
            }
        }

        @Override
        public void visitLocalState(UnitOfWork.LocalStateVisitor visitor) {
            for (File localStateFile : this.context.getTaskProperties().getLocalStateFiles()) {
                visitor.visitLocalStateRoot(localStateFile);
            }
        }

        @Override
        public UnitOfWork.OverlappingOutputHandling getOverlappingOutputHandling() {
            return UnitOfWork.OverlappingOutputHandling.DETECT_OVERLAPS;
        }

        @Override
        public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
            return this.getInputChangeTrackingStrategy() == UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
        }

        @Override
        public Iterable<String> getChangingOutputs() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.visitOutputProperties((propertyName, type, root) -> builder.add((Object)root.getAbsolutePath()));
            this.context.getTaskProperties().getDestroyableFiles().forEach(file -> builder.add((Object)file.getAbsolutePath()));
            this.context.getTaskProperties().getLocalStateFiles().forEach(file -> builder.add((Object)file.getAbsolutePath()));
            return builder.build();
        }

        @Override
        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            if (this.task.isHasCustomActions()) {
                LOGGER.info("Custom actions are attached to {}.", (Object)this.task);
            }
            return ExecuteActionsTaskExecuter.this.taskCacheabilityResolver.shouldDisableCaching(this.context.getTaskProperties().hasDeclaredOutputs(), this.context.getTaskProperties().getOutputFileProperties(), this.task, this.task.getOutputs().getCacheIfSpecs(), this.task.getOutputs().getDoNotCacheIfSpecs(), detectedOverlappingOutputs);
        }

        @Override
        public boolean isAllowedToLoadFromCache() {
            return this.context.getTaskExecutionMode().isAllowedToUseCachedResults();
        }

        @Override
        public Optional<Duration> getTimeout() {
            return Optional.ofNullable((Duration)this.task.getTimeout().getOrNull());
        }

        @Override
        public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
            for (InputChangesAwareTaskAction taskAction : this.task.getTaskActions()) {
                if (taskAction instanceof IncrementalInputsTaskAction) {
                    return UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS;
                }
                if (!(taskAction instanceof IncrementalTaskInputsTaskAction)) continue;
                return UnitOfWork.InputChangeTrackingStrategy.ALL_PARAMETERS;
            }
            return UnitOfWork.InputChangeTrackingStrategy.NONE;
        }

        @Override
        public ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputsBeforeExecution() {
            return this.snapshotOutputs();
        }

        @Override
        public ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputsAfterExecution() {
            return this.snapshotOutputs();
        }

        private ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputs() {
            ImmutableSortedSet<OutputFilePropertySpec> outputFilePropertySpecs = this.context.getTaskProperties().getOutputFileProperties();
            return ExecuteActionsTaskExecuter.this.taskSnapshotter.snapshotTaskFiles(this.task, (SortedSet<? extends FilePropertySpec>)outputFilePropertySpecs);
        }

        @Override
        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintAndFilterOutputSnapshots(ImmutableSortedMap<String, FileCollectionFingerprint> afterPreviousExecutionOutputFingerprints, ImmutableSortedMap<String, FileSystemSnapshot> beforeExecutionOutputSnapshots, ImmutableSortedMap<String, FileSystemSnapshot> afterExecutionOutputSnapshots, boolean hasDetectedOverlappingOutputs) {
            return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(afterExecutionOutputSnapshots, (propertyName, afterExecutionOutputSnapshot) -> {
                FileCollectionFingerprint afterLastExecutionFingerprint = (FileCollectionFingerprint)afterPreviousExecutionOutputFingerprints.get(propertyName);
                FileSystemSnapshot beforeExecutionOutputSnapshot = (FileSystemSnapshot)beforeExecutionOutputSnapshots.get(propertyName);
                assert (afterExecutionOutputSnapshot != null);
                return this.fingerprintOutputSnapshot(afterLastExecutionFingerprint, beforeExecutionOutputSnapshot, (FileSystemSnapshot)afterExecutionOutputSnapshot, hasDetectedOverlappingOutputs);
            }));
        }

        private CurrentFileCollectionFingerprint fingerprintOutputSnapshot(@Nullable FileCollectionFingerprint afterLastExecutionFingerprint, FileSystemSnapshot beforeExecutionOutputSnapshot, FileSystemSnapshot afterExecutionOutputSnapshot, boolean hasOverlappingOutputs) {
            ImmutableList<FileSystemSnapshot> roots = hasOverlappingOutputs ? OutputFilterUtil.filterOutputSnapshotAfterExecution(afterLastExecutionFingerprint, beforeExecutionOutputSnapshot, afterExecutionOutputSnapshot) : ImmutableList.of((Object)afterExecutionOutputSnapshot);
            return DefaultCurrentFileCollectionFingerprint.from(roots, AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
        }

        @Override
        public long markExecutionTime() {
            return this.context.markExecutionTime();
        }

        @Override
        public void markLegacySnapshottingInputsStarted() {
            if (ExecuteActionsTaskExecuter.this.buildCacheState == BuildCacheState.ENABLED || ExecuteActionsTaskExecuter.this.scanPluginState == ScanPluginState.APPLIED) {
                BuildOperationContext operationContext = ExecuteActionsTaskExecuter.this.buildOperationExecutor.start(BuildOperationDescriptor.displayName("Snapshot task inputs for " + this.task.getIdentityPath()).name("Snapshot task inputs").details(SnapshotTaskInputsBuildOperationType.Details.INSTANCE));
                this.context.setSnapshotTaskInputsBuildOperationContext(operationContext);
            }
        }

        @Override
        public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
            this.context.removeSnapshotTaskInputsBuildOperationContext().ifPresent(operation -> operation.setResult(new SnapshotTaskInputsBuildOperationResult(cachingState)));
        }

        @Override
        public void ensureLegacySnapshottingInputsClosed() {
            this.context.removeSnapshotTaskInputsBuildOperationContext().ifPresent(operation -> operation.setResult(new SnapshotTaskInputsBuildOperationResult(CachingState.NOT_DETERMINED)));
        }

        @Override
        public void validate(UnitOfWork.WorkValidationContext validationContext) {
            Class<?> taskType = GeneratedSubclasses.unpackType(this.task);
            boolean cacheable = taskType.isAnnotationPresent(CacheableTask.class);
            this.context.getTaskProperties().validate(new DefaultTaskValidationContext(ExecuteActionsTaskExecuter.this.fileOperations, ExecuteActionsTaskExecuter.this.reservedFileSystemLocationRegistry, validationContext.createContextFor(taskType, cacheable)));
        }

        @Override
        public Optional<ExecutionOutcome> skipIfInputsEmpty(ImmutableSortedMap<String, FileCollectionFingerprint> outputFilesAfterPreviousExecution) {
            TaskProperties properties = this.context.getTaskProperties();
            FileCollection inputFiles = properties.getInputFiles();
            FileCollection sourceFiles = properties.getSourceFiles();
            boolean hasSourceFiles = properties.hasSourceFiles();
            return ExecuteActionsTaskExecuter.this.emptySourceTaskSkipper.skipIfEmptySources(this.task, hasSourceFiles, inputFiles, sourceFiles, (Map<String, FileCollectionFingerprint>)outputFilesAfterPreviousExecution);
        }

        @Override
        public String getDisplayName() {
            return this.task.toString();
        }
    }

    public static enum ScanPluginState {
        APPLIED,
        NOT_APPLIED;

    }

    public static enum BuildCacheState {
        ENABLED,
        DISABLED;

    }
}

