/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.scala.GuavaBackedClassLoaderCache;
import sbt.internal.inc.classpath.AbstractClassLoaderCache;
import sbt.io.IO;
import scala.Function0;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;

class TimeCheckingClassLoaderCache
implements AbstractClassLoaderCache {
    private final URLClassLoader commonParent = new URLClassLoader(new URL[0]);
    private final GuavaBackedClassLoaderCache<Set<TimestampedFile>> cache;

    public TimeCheckingClassLoaderCache(int maxSize) {
        this.cache = new GuavaBackedClassLoaderCache(maxSize);
    }

    public ClassLoader commonParent() {
        return this.commonParent;
    }

    public ClassLoader apply(List<File> files2) {
        try {
            java.util.List jFiles = JavaConverters.seqAsJavaList(files2);
            return this.cache.get(this.getTimestampedFiles(jFiles), () -> {
                ArrayList<URL> urls = new ArrayList<URL>(jFiles.size());
                for (File f : jFiles) {
                    urls.add(f.toURI().toURL());
                }
                return new URLClassLoader(urls.toArray(new URL[0]), (ClassLoader)this.commonParent);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader cachedCustomClassloader(List<File> files2, Function0<ClassLoader> mkLoader) {
        try {
            return this.cache.get(this.getTimestampedFiles(JavaConverters.seqAsJavaList(files2)), () -> (ClassLoader)mkLoader.apply());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<TimestampedFile> getTimestampedFiles(java.util.List<File> fs) {
        return fs.stream().map(TimestampedFile::new).collect(Collectors.toSet());
    }

    public void close() throws IOException {
        this.cache.clear();
        this.commonParent.close();
    }

    static class TimestampedFile {
        private final File file;
        private final long timestamp;

        public TimestampedFile(File file) {
            this.file = file;
            this.timestamp = IO.getModifiedTimeOrZero((File)file);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimestampedFile that = (TimestampedFile)o;
            return this.timestamp == that.timestamp && Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.timestamp);
        }
    }
}

