/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.PublicationArtifact;
import org.gradle.api.publish.internal.PublicationFieldValidator;
import org.gradle.api.publish.maven.InvalidMavenPublicationException;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.impldep.org.apache.commons.lang.ObjectUtils;
import org.gradle.internal.impldep.org.apache.maven.model.Model;
import org.gradle.internal.impldep.org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.gradle.internal.impldep.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ValidatingMavenPublisher
implements MavenPublisher {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";
    private final MavenPublisher delegate;

    public ValidatingMavenPublisher(MavenPublisher delegate) {
        this.delegate = delegate;
    }

    @Override
    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        this.validateIdentity(publication);
        this.validateArtifacts(publication);
        this.checkNoDuplicateArtifacts(publication);
        this.delegate.publish(publication, artifactRepository);
    }

    private void validateIdentity(MavenNormalizedPublication publication) {
        Model model = this.parsePomFileIntoMavenModel(publication);
        this.field(publication, "artifactId", publication.getArtifactId()).validMavenIdentifier().matches(model.getArtifactId());
        boolean hasParentPom = model.getParent() != null;
        MavenFieldValidator groupIdValidator = this.field(publication, "groupId", publication.getGroupId()).validMavenIdentifier();
        MavenFieldValidator versionValidator = (MavenFieldValidator)((MavenFieldValidator)this.field(publication, "version", publication.getVersion()).notEmpty()).validInFileName();
        if (!hasParentPom) {
            groupIdValidator.matches(model.getGroupId());
            versionValidator.matches(model.getVersion());
        }
    }

    private Model parsePomFileIntoMavenModel(MavenNormalizedPublication publication) {
        File pomFile = publication.getPomArtifact().getFile();
        try {
            Model model = this.readModelFromPom(pomFile);
            model.setPomFile(pomFile);
            return model;
        }
        catch (XmlPullParserException parseException) {
            throw new InvalidMavenPublicationException(publication.getName(), "POM file is invalid. Check any modifications you have made to the POM file.", parseException);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Model readModelFromPom(File pomFile) throws IOException, XmlPullParserException {
        try (FileReader reader = new FileReader(pomFile);){
            Model model = new MavenXpp3Reader().read((Reader)reader);
            return model;
        }
    }

    private void validateArtifacts(MavenNormalizedPublication publication) {
        for (MavenArtifact artifact : publication.getAllArtifacts()) {
            ((MavenFieldValidator)this.field(publication, "artifact extension", artifact.getExtension()).notNull()).validInFileName();
            ((MavenFieldValidator)this.field(publication, "artifact classifier", artifact.getClassifier()).optionalNotEmpty()).validInFileName();
            this.checkCanPublish(publication.getName(), artifact);
        }
    }

    private void checkNoDuplicateArtifacts(MavenNormalizedPublication publication) {
        HashSet<MavenArtifact> verified = new HashSet<MavenArtifact>();
        for (MavenArtifact artifact : publication.getAllArtifacts()) {
            this.checkNotDuplicate(publication, verified, artifact.getExtension(), artifact.getClassifier());
            verified.add(artifact);
        }
    }

    private void checkNotDuplicate(MavenNormalizedPublication publication, Set<MavenArtifact> artifacts, String extension, String classifier) {
        for (MavenArtifact artifact : artifacts) {
            if (!ObjectUtils.equals((Object)artifact.getExtension(), (Object)extension) || !ObjectUtils.equals((Object)artifact.getClassifier(), (Object)classifier)) continue;
            String message2 = String.format("multiple artifacts with the identical extension and classifier ('%s', '%s').", extension, classifier);
            throw new InvalidMavenPublicationException(publication.getName(), message2);
        }
    }

    private void checkCanPublish(String publicationName, PublicationArtifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile == null || !artifactFile.exists()) {
            throw new InvalidMavenPublicationException(publicationName, String.format("artifact file does not exist: '%s'", artifactFile));
        }
        if (artifactFile.isDirectory()) {
            throw new InvalidMavenPublicationException(publicationName, String.format("artifact file is a directory: '%s'", artifactFile));
        }
    }

    private MavenFieldValidator field(MavenNormalizedPublication publication, String name, String value) {
        return new MavenFieldValidator(publication.getName(), name, value);
    }

    private static class MavenFieldValidator
    extends PublicationFieldValidator<MavenFieldValidator> {
        private MavenFieldValidator(String publicationName, String name, String value) {
            super(MavenFieldValidator.class, publicationName, name, value);
        }

        public MavenFieldValidator validMavenIdentifier() {
            this.notEmpty();
            if (!this.value.matches(ValidatingMavenPublisher.ID_REGEX)) {
                throw this.failure(String.format("%s (%s) is not a valid Maven identifier (%s).", this.name, this.value, ValidatingMavenPublisher.ID_REGEX));
            }
            return this;
        }

        public MavenFieldValidator matches(String valueFromPomFile) {
            if (!this.value.equals(valueFromPomFile)) {
                throw this.failure(String.format("supplied %s (%s) does not match value from POM file (%s). Cannot edit %1$s directly in the POM file.", this.name, this.value, valueFromPomFile));
            }
            return this;
        }

        @Override
        protected InvalidMavenPublicationException failure(String message2) {
            return new InvalidMavenPublicationException(this.publicationName, message2);
        }
    }
}

