/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.Path;

public class DefaultIncludedBuildTaskGraph
implements IncludedBuildTaskGraph {
    private final Multimap<BuildIdentifier, BuildIdentifier> buildDependencies = LinkedHashMultimap.create();
    private final IncludedBuildControllers includedBuilds;

    public DefaultIncludedBuildTaskGraph(IncludedBuildControllers includedBuilds) {
        this.includedBuilds = includedBuilds;
    }

    @Override
    public synchronized void addTask(BuildIdentifier requestingBuild, BuildIdentifier targetBuild, String taskPath) {
        boolean newBuildDependency = this.buildDependencies.put((Object)requestingBuild, (Object)targetBuild);
        if (newBuildDependency) {
            ArrayList candidateCycle = Lists.newArrayList();
            this.checkNoCycles(requestingBuild, targetBuild, candidateCycle);
        }
        this.getBuildController(targetBuild).queueForExecution(taskPath);
    }

    @Override
    public void awaitTaskCompletion(Collection<? super Throwable> taskFailures) {
        this.includedBuilds.populateTaskGraphs();
        this.includedBuilds.startTaskExecution();
        this.includedBuilds.awaitTaskCompletion(taskFailures);
    }

    @Override
    public IncludedBuildTaskResource.State getTaskState(BuildIdentifier targetBuild, String taskPath) {
        IncludedBuildController controller = this.getBuildController(targetBuild);
        return controller.getTaskState(taskPath);
    }

    private IncludedBuildController getBuildController(BuildIdentifier buildId) {
        return this.includedBuilds.getBuildController(buildId);
    }

    private void checkNoCycles(BuildIdentifier sourceBuild, BuildIdentifier targetBuild, List<BuildIdentifier> candidateCycle) {
        candidateCycle.add(targetBuild);
        for (BuildIdentifier nextTarget : this.buildDependencies.get((Object)targetBuild)) {
            if (sourceBuild.equals(nextTarget)) {
                candidateCycle.add(nextTarget);
                DefaultProjectComponentSelector selector = new DefaultProjectComponentSelector(candidateCycle.get(0), Path.ROOT, Path.ROOT, ":", ImmutableAttributes.EMPTY, Collections.emptyList());
                throw new ModuleVersionResolveException((ComponentSelector)selector, () -> "Included build dependency cycle: " + this.reportCycle(candidateCycle));
            }
            this.checkNoCycles(sourceBuild, nextTarget, candidateCycle);
        }
        candidateCycle.remove(targetBuild);
    }

    private String reportCycle(List<BuildIdentifier> cycle) {
        StringBuilder cycleReport = new StringBuilder();
        for (BuildIdentifier buildIdentifier : cycle) {
            cycleReport.append(buildIdentifier);
            cycleReport.append(" -> ");
        }
        cycleReport.append(cycle.get(0));
        return cycleReport.toString();
    }
}

