/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public class SingleDepthFileAccessTracker
implements FileAccessTracker {
    private final Path baseDir;
    private final int endNameIndex;
    private final int startNameIndex;
    private final FileAccessTimeJournal journal;

    public SingleDepthFileAccessTracker(FileAccessTimeJournal journal, File baseDir, int depth) {
        this.journal = journal;
        Preconditions.checkArgument((depth > 0 ? 1 : 0) != 0, (String)"depth must be > 0: %s", (int)depth);
        this.baseDir = baseDir.toPath().toAbsolutePath();
        this.startNameIndex = this.baseDir.getNameCount();
        this.endNameIndex = this.startNameIndex + depth;
    }

    @Override
    public void markAccessed(File file) {
        this.markAccessed(this.toSubPath(file));
    }

    @Override
    public void markAccessed(Collection<File> files2) {
        for (Path path : this.collectSubPaths(files2)) {
            this.markAccessed(path);
        }
    }

    private void markAccessed(@Nullable Path path) {
        if (path != null) {
            this.journal.setLastAccessTime(path.toFile(), System.currentTimeMillis());
        }
    }

    private Set<Path> collectSubPaths(Collection<File> files2) {
        HashSet<Path> paths = new HashSet<Path>();
        for (File file : files2) {
            paths.add(this.toSubPath(file));
        }
        return paths;
    }

    @Nullable
    private Path toSubPath(File file) {
        Path path = file.toPath().toAbsolutePath();
        if (path.getNameCount() >= this.endNameIndex && path.startsWith(this.baseDir)) {
            return this.baseDir.resolve(path.subpath(this.startNameIndex, this.endNameIndex));
        }
        return null;
    }
}

