/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddress;
import org.gradle.internal.remote.internal.inet.MultiChoiceAddressSerializer;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;

public class DaemonStartupCommunication {
    private static final Logger LOGGER = Logging.getLogger(DaemonStartupCommunication.class);

    public void printDaemonStarted(PrintStream target, Long pid, String uid, Address address, File daemonLog) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(DaemonStartupCommunication.daemonGreeting().getBytes());
            EncodedStream.EncodedOutput outputStream = new EncodedStream.EncodedOutput(byteArrayOutputStream);
            OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder(outputStream);
            encoder.writeNullableString(pid == null ? null : pid.toString());
            encoder.writeString(uid);
            MultiChoiceAddress multiChoiceAddress = (MultiChoiceAddress)address;
            new MultiChoiceAddressSerializer().write((Encoder)encoder, multiChoiceAddress);
            encoder.writeString(daemonLog.getPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        target.println(byteArrayOutputStream.toString());
        LOGGER.debug("Completed writing the daemon greeting. Closing streams...");
    }

    public DaemonStartupInfo readDiagnostics(String message2) {
        if (!message2.startsWith(DaemonStartupCommunication.daemonGreeting())) {
            throw new IllegalArgumentException(String.format("Unexpected daemon startup message: %s", message2));
        }
        try {
            String encoded = message2.substring(DaemonStartupCommunication.daemonGreeting().length()).trim();
            EncodedStream.EncodedInput inputStream = new EncodedStream.EncodedInput(new ByteArrayInputStream(encoded.getBytes()));
            InputStreamBackedDecoder decoder = new InputStreamBackedDecoder(inputStream);
            String pidString = decoder.readNullableString();
            String uid = decoder.readString();
            Long pid = pidString == null ? null : Long.valueOf(pidString);
            MultiChoiceAddress address = new MultiChoiceAddressSerializer().read(decoder);
            File daemonLog = new File(decoder.readString());
            return new DaemonStartupInfo(uid, address, new DaemonDiagnostics(daemonLog, pid));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean containsGreeting(String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException("Unable to detect the daemon greeting because the input message is null!");
        }
        return message2.contains(DaemonStartupCommunication.daemonGreeting());
    }

    private static String daemonGreeting() {
        return "Daemon started. About to close the streams. Daemon details: ";
    }
}

