/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppPlatform;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.nativeplatform.tasks.UnexportMainSymbol;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;

public class CppUnitTestPlugin
implements Plugin<Project> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        ProviderFactory providers = project.getProviders();
        TaskContainer tasks = project.getTasks();
        final DefaultCppTestSuite testComponent = this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", testComponent);
        project.getComponents().add(testComponent);
        testComponent.getBaseName().convention(project.getName() + "Test");
        testComponent.getTargetMachines().convention(Dimensions.useHostAsDefaultTargetMachine(this.targetMachineFactory));
        String mainComponentName = "main";
        project.getComponents().withType(ProductionCppComponent.class, component -> {
            if ("main".equals(component.getName())) {
                testComponent.getTargetMachines().convention(component.getTargetMachines());
                testComponent.getTestedComponent().convention((CppComponent)component);
            }
        });
        testComponent.getTestBinary().convention(project.provider(new Callable<CppTestExecutable>(){

            @Override
            public CppTestExecutable call() throws Exception {
                return this.getAllBuildableTestExecutable().filter(it -> this.isCurrentArchitecture(it.getNativePlatform())).findFirst().orElse(this.getAllBuildableTestExecutable().findFirst().orElse(this.getAllTestExecutable().findFirst().orElse(null)));
            }

            private boolean isCurrentArchitecture(NativePlatform targetPlatform) {
                return targetPlatform.getArchitecture().equals(DefaultNativePlatform.getCurrentArchitecture());
            }

            private Stream<DefaultCppTestExecutable> getAllBuildableTestExecutable() {
                return this.getAllTestExecutable().filter(it -> it.getPlatformToolProvider().isAvailable());
            }

            private Stream<DefaultCppTestExecutable> getAllTestExecutable() {
                return ((DefaultBinaryCollection)testComponent.getBinaries()).get().stream().filter(CppTestExecutable.class::isInstance).map(DefaultCppTestExecutable.class::cast);
            }
        }));
        ((DefaultBinaryCollection)testComponent.getBinaries()).whenElementKnown(DefaultCppTestExecutable.class, binary -> {
            NamedDomainObjectProvider testTask = tasks.register(binary.getNames().getTaskName("run"), RunTestExecutable.class, task -> {
                task.setGroup("verification");
                task.setDescription("Executes C++ unit tests.");
                InstallExecutable installTask = (InstallExecutable)binary.getInstallTask().get();
                task.onlyIf(element -> ((Directory)binary.getInstallDirectory().get()).getAsFile().exists());
                task.getInputs().dir(binary.getInstallDirectory());
                task.setExecutable(installTask.getRunScriptFile().get().getAsFile());
                task.dependsOn(binary.getInstallDirectory());
                task.setOutputDir(project.getLayout().getBuildDirectory().dir("test-results/" + binary.getNames().getDirName()).get().getAsFile());
            });
            binary.getRunTask().set(testTask);
            this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, (DefaultCppTestExecutable)binary);
        });
        project.afterEvaluate(p -> {
            CppComponent mainComponent = (CppComponent)testComponent.getTestedComponent().getOrNull();
            SetProperty<TargetMachine> mainTargetMachines = mainComponent != null ? mainComponent.getTargetMachines() : null;
            Dimensions.unitTestVariants(testComponent.getBaseName(), testComponent.getTargetMachines(), mainTargetMachines, this.objectFactory, this.attributesFactory, providers.provider(() -> project.getGroup().toString()), providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost(variantIdentity)) {
                    ToolChainSelector.Result<DefaultCppPlatform> result = this.toolChainSelector.select(CppPlatform.class, new DefaultCppPlatform(variantIdentity.getTargetMachine()));
                    CppTestExecutable cppTestExecutable = testComponent.addExecutable(variantIdentity.getName().replace("debug", ""), (NativeVariantIdentity)variantIdentity, result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                }
            });
            ((DefaultBinaryCollection)testComponent.getBinaries()).realizeNow();
        });
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project, DefaultCppTestSuite testSuite, DefaultCppTestExecutable testExecutable) {
        CppComponent target = (CppComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionCppComponent)) {
            return;
        }
        ProductionCppComponent testedComponent = (ProductionCppComponent)target;
        TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized(testedBinary -> {
            if (!this.isTestedBinary(testExecutable, testedComponent, (CppBinary)testedBinary)) {
                return;
            }
            testExecutable.getImplementationDependencies().extendsFrom(((DefaultCppBinary)testedBinary).getImplementationDependencies());
            ConfigurableFileCollection testableObjects = project.files(new Object[0]);
            if (target instanceof CppApplication) {
                NamedDomainObjectProvider unexportMainSymbol = tasks.register(testExecutable.getNames().getTaskName("relocateMainFor"), UnexportMainSymbol.class, task -> {
                    String dirName = ((DefaultCppBinary)testedBinary).getNames().getDirName();
                    task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/for-test/" + dirName));
                    task.getObjects().from(testedBinary.getObjects());
                });
                testableObjects.from(unexportMainSymbol.map(task -> task.getRelocatedObjects()));
            } else {
                testableObjects.from(testedBinary.getObjects());
            }
            Dependency linkDependency = project.getDependencies().create(testableObjects);
            testExecutable.getLinkConfiguration().getDependencies().add(linkDependency);
        });
    }

    private boolean isTestedBinary(DefaultCppTestExecutable testExecutable, ProductionCppComponent mainComponent, CppBinary testedBinary) {
        return testedBinary.getTargetMachine().getOperatingSystemFamily().getName().equals(testExecutable.getTargetMachine().getOperatingSystemFamily().getName()) && testedBinary.getTargetMachine().getArchitecture().getName().equals(testExecutable.getTargetMachine().getArchitecture().getName()) && !testedBinary.isOptimized() && this.hasDevelopmentBinaryLinkage(mainComponent, testedBinary);
    }

    private boolean hasDevelopmentBinaryLinkage(ProductionCppComponent mainComponent, CppBinary testedBinary) {
        if (!(testedBinary instanceof ConfigurableComponentWithLinkUsage)) {
            return true;
        }
        ConfigurableComponentWithLinkUsage developmentBinaryWithUsage = (ConfigurableComponentWithLinkUsage)((Object)mainComponent.getDevelopmentBinary().get());
        ConfigurableComponentWithLinkUsage testedBinaryWithUsage = (ConfigurableComponentWithLinkUsage)((Object)testedBinary);
        return testedBinaryWithUsage.getLinkage() == developmentBinaryWithUsage.getLinkage();
    }
}

