/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.normalization.internal;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.changedetection.state.IgnoringResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.IgnoringResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.normalization.MetaInfNormalization;
import org.gradle.normalization.internal.RuntimeClasspathNormalizationInternal;

public class DefaultRuntimeClasspathNormalization
implements RuntimeClasspathNormalizationInternal {
    private final MetaInfNormalization metaInfNormalization = new RuntimeMetaInfNormalization();
    private final EvaluatableFilter<ResourceFilter> resourceFilter = DefaultRuntimeClasspathNormalization.filter(IgnoringResourceFilter::new, ResourceFilter.FILTER_NOTHING);
    private final EvaluatableFilter<ResourceEntryFilter> manifestAttributeResourceFilter = DefaultRuntimeClasspathNormalization.filter(IgnoringResourceEntryFilter::new, ResourceEntryFilter.FILTER_NOTHING);
    private final EvaluatableFilter<ResourceEntryFilter> manifestPropertyResourceFilter = DefaultRuntimeClasspathNormalization.filter(IgnoringResourceEntryFilter::new, ResourceEntryFilter.FILTER_NOTHING);

    @Override
    public void ignore(String pattern) {
        this.resourceFilter.ignore(pattern);
    }

    @Override
    public void metaInf(Action<? super MetaInfNormalization> configuration) {
        configuration.execute(this.metaInfNormalization);
    }

    @Override
    public ResourceFilter getClasspathResourceFilter() {
        return this.resourceFilter.evaluate();
    }

    @Override
    public ResourceEntryFilter getManifestAttributeResourceEntryFilter() {
        return this.manifestAttributeResourceFilter.evaluate();
    }

    @Override
    public ResourceEntryFilter getManifestPropertyResourceEntryFilter() {
        return this.manifestPropertyResourceFilter.evaluate();
    }

    private static <T> EvaluatableFilter<T> filter(Function<ImmutableSet<String>, T> initializer, T emptyValue) {
        return new EvaluatableFilter<T>(initializer, emptyValue);
    }

    private static class EvaluatableFilter<T> {
        private T value;
        private final Supplier<T> valueSupplier;
        private final ImmutableSet.Builder<String> builder = ImmutableSet.builder();

        public EvaluatableFilter(Function<ImmutableSet<String>, T> initializer, T emptyValue) {
            this.valueSupplier = () -> Optional.of(this.builder.build()).filter(ignores -> !ignores.isEmpty()).map(initializer).orElse(emptyValue);
        }

        public T evaluate() {
            if (this.value == null) {
                this.value = this.valueSupplier.get();
            }
            return this.value;
        }

        private void checkNotEvaluated() {
            if (this.value != null) {
                throw new GradleException("Cannot configure runtime classpath normalization after execution started.");
            }
        }

        public void ignore(String ignore) {
            this.checkNotEvaluated();
            this.builder.add((Object)ignore);
        }
    }

    public class RuntimeMetaInfNormalization
    implements MetaInfNormalization {
        @Override
        public void ignoreCompletely() {
            DefaultRuntimeClasspathNormalization.this.ignore("META-INF/*");
        }

        @Override
        public void ignoreManifest() {
            DefaultRuntimeClasspathNormalization.this.ignore("META-INF/MANIFEST.MF");
        }

        @Override
        public void ignoreAttribute(String name) {
            DefaultRuntimeClasspathNormalization.this.manifestAttributeResourceFilter.ignore(name.toLowerCase(Locale.ROOT));
        }

        @Override
        public void ignoreProperty(String name) {
            DefaultRuntimeClasspathNormalization.this.manifestPropertyResourceFilter.ignore(name);
        }
    }
}

