/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.apache.lucene.search.Query;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

public class MavenServerCMDState
extends CommandLineState {
    private static boolean setupThrowMainClass = false;
    @NonNls
    private static final String MAIN_CLASS = "org.jetbrains.idea.maven.server.RemoteMavenServer";
    @NonNls
    private static final String MAIN_CLASS36 = "org.jetbrains.idea.maven.server.RemoteMavenServer36";
    @NonNls
    private static final String MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS = "org.jetbrains.idea.maven.server.RemoteMavenServerThrowsExceptionForTests";
    private final Sdk myJdk;
    private final String myVmOptions;
    private final MavenDistribution myDistribution;
    private final Project myProject;
    private final Integer myDebugPort;

    public MavenServerCMDState(@NotNull Sdk jdk, @Nullable String vmOptions, @Nullable MavenDistribution mavenDistribution, Project project, @Nullable Integer debugPort) {
        if (jdk == null) {
            MavenServerCMDState.$$$reportNull$$$0(0);
        }
        super(null);
        this.myJdk = jdk;
        this.myVmOptions = vmOptions;
        this.myDistribution = mavenDistribution;
        this.myProject = project;
        this.myDebugPort = debugPort;
    }

    /*
     * WARNING - void declaration
     */
    SimpleJavaParameters createJavaParameters() {
        String mavenEmbedderCliOptions;
        void var4_12;
        String mavenVersion;
        MavenDistribution distribution;
        SimpleJavaParameters params = new SimpleJavaParameters();
        params.setJdk(this.myJdk);
        params.setWorkingDirectory(PathManager.getBinPath());
        THashMap defs = new THashMap();
        defs.putAll(MavenUtil.getPropertiesFromMavenOpts());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Iterator key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String) || !((String)((Object)key)).startsWith("javax.net.ssl")) continue;
            defs.put((String)((Object)key), (String)value);
        }
        defs.put("java.awt.headless", "true");
        for (Map.Entry<Object, Object> entry : defs.entrySet()) {
            params.getVMParametersList().defineProperty((String)entry.getKey(), (String)entry.getValue());
        }
        params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
        if (this.myDebugPort != null) {
            params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + this.myDebugPort);
        }
        params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
        boolean xmxSet = false;
        if (this.myVmOptions != null) {
            ParametersList parametersList = new ParametersList();
            parametersList.addParametersString(this.myVmOptions);
            for (String param : parametersList.getParameters()) {
                if (param.startsWith("-Xmx")) {
                    xmxSet = true;
                }
                params.getVMParametersList().add(param);
            }
        }
        if ((distribution = this.myDistribution) == null) {
            MavenLog.LOG.warn("Not found maven at ");
            MavenDistribution embedded = MavenServerManager.resolveEmbeddedMavenHome();
            File file = embedded.getMavenHome();
            mavenVersion = embedded.getVersion();
            this.showInvalidMavenNotification(mavenVersion);
        } else {
            File file = distribution.getMavenHome();
            mavenVersion = distribution.getVersion();
        }
        MavenLog.LOG.debug("", new Object[]{distribution, " chosen as maven home"});
        assert (mavenVersion != null);
        MavenServerCMDState.setupMainClass(params, mavenVersion);
        params.getVMParametersList().addProperty("idea.maven.embedder.version", mavenVersion);
        ArrayList<String> classPath = new ArrayList<String>();
        classPath.add(PathUtil.getJarPathForClass(org.apache.log4j.Logger.class));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
            classPath.add(PathUtil.getJarPathForClass(Logger.class));
            classPath.add(PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
        }
        classPath.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        classPath.add(PathUtil.getJarPathForClass(NotNull.class));
        classPath.add(PathUtil.getJarPathForClass(Element.class));
        classPath.add(PathUtil.getJarPathForClass(TIntHashSet.class));
        ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(Query.class));
        params.getClassPath().add(PathManager.getResourceRoot(((Object)((Object)this)).getClass(), (String)"/messages/CommonBundle.properties"));
        params.getClassPath().addAll(classPath);
        params.getClassPath().addAllFiles(MavenServerManager.collectClassPathAndLibsFolder(mavenVersion, (File)var4_12));
        String embedderXmx = System.getProperty("idea.maven.embedder.xmx");
        if (embedderXmx != null) {
            params.getVMParametersList().add("-Xmx" + embedderXmx);
        } else if (!xmxSet) {
            params.getVMParametersList().add("-Xmx768m");
        }
        String mavenEmbedderParameters = System.getProperty("idea.maven.embedder.parameters");
        if (mavenEmbedderParameters != null) {
            params.getProgramParametersList().addParametersString(mavenEmbedderParameters);
        }
        if ((mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args")) != null) {
            params.getVMParametersList().addProperty("idea.maven.embedder.ext.cli.args", mavenEmbedderCliOptions);
        }
        MavenUtil.addEventListener(mavenVersion, params);
        return params;
    }

    private static void setupMainClass(SimpleJavaParameters params, String mavenVersion) {
        if (setupThrowMainClass && ApplicationManager.getApplication().isUnitTestMode()) {
            setupThrowMainClass = false;
            params.setMainClass(MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS);
        } else if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
            params.setMainClass(MAIN_CLASS36);
        } else {
            params.setMainClass(MAIN_CLASS);
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            MavenServerCMDState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            MavenServerCMDState.$$$reportNull$$$0(2);
        }
        OSProcessHandler processHandler = this.startProcess();
        return new DefaultExecutionResult((ProcessHandler)processHandler);
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        SimpleJavaParameters params = this.createJavaParameters();
        GeneralCommandLine commandLine = params.toCommandLine();
        OSProcessHandler.Silent processHandler = new OSProcessHandler.Silent(commandLine);
        processHandler.setShouldDestroyProcessRecursively(false);
        OSProcessHandler.Silent silent = processHandler;
        if (silent == null) {
            MavenServerCMDState.$$$reportNull$$$0(3);
        }
        return silent;
    }

    private void showInvalidMavenNotification(@Nullable @NlsSafe String mavenVersion) {
        String message = MavenServerCMDState.invalidHomeMessageToShow(this.myDistribution, mavenVersion, this.myProject);
        NotificationListener listener2 = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(MavenServerCMDState.this.myProject, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/server/MavenServerCMDState$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        new Notification("Maven", "", message, NotificationType.WARNING, listener2).notify(this.myProject);
    }

    @BuildEventsNls.Message
    private static String invalidHomeMessageToShow(@Nullable MavenDistribution mavenDistribution, @NlsSafe String substitutedVersion, Project project) {
        String wrongDir;
        if (mavenDistribution != null && StringUtil.equals((CharSequence)"Bundled (Maven 2)", (CharSequence)mavenDistribution.getName())) {
            if (project == null) {
                return RunnerBundle.message("bundled.maven.maven2.not.supported", new Object[0]);
            }
            return RunnerBundle.message("bundled.maven.maven2.not.supported.with.fix", new Object[0]);
        }
        String string = wrongDir = mavenDistribution == null ? null : mavenDistribution.getMavenHome().getAbsolutePath();
        if (project == null) {
            return RunnerBundle.message("external.maven.home.invalid.substitution.warning", wrongDir, substitutedVersion);
        }
        return RunnerBundle.message("external.maven.home.invalid.substitution.warning.with.fix", wrongDir, substitutedVersion);
    }

    @TestOnly
    public static void setThrowExceptionOnNextServerStart() {
        setupThrowMainClass = true;
    }

    @TestOnly
    public static void resetThrowExceptionOnNextServerStart() {
        setupThrowMainClass = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerCMDState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerCMDState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

