/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.externalSystem.importing.AbstractOpenProjectProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenOpenProjectProvider;", "Lcom/intellij/openapi/externalSystem/importing/AbstractOpenProjectProvider;", "()V", "builder", "Lorg/jetbrains/idea/maven/wizards/MavenProjectBuilder;", "getBuilder", "()Lorg/jetbrains/idea/maven/wizards/MavenProjectBuilder;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "isProjectFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "linkAndRefreshProject", "", "projectDirectory", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenOpenProjectProvider
extends AbstractOpenProjectProvider {
    @NotNull
    private final ProjectSystemId systemId;

    @NotNull
    protected ProjectSystemId getSystemId() {
        return this.systemId;
    }

    @NotNull
    public final MavenProjectBuilder getBuilder() {
        Object object = ProjectImportBuilder.EXTENSIONS_POINT_NAME.findExtensionOrFail(MavenProjectBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProjectImportBuilder.EXT\u2026ojectBuilder::class.java)");
        return (MavenProjectBuilder)((Object)object);
    }

    protected boolean isProjectFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MavenUtil.isPomFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void linkAndRefreshProject(@NotNull Path projectDirectory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MavenProjectBuilder builder = this.getBuilder();
        try {
            builder.setUpdate(false);
            builder.setFileToImport(projectDirectory);
            if (builder.validate(null, project)) {
                builder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
        }
        finally {
            builder.cleanup();
        }
    }

    public MavenOpenProjectProvider() {
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"MavenUtil.SYSTEM_ID");
        this.systemId = projectSystemId;
    }
}

