/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/grazie/utils/Text;", "", "()V", "PUNCTUATIONS", "", "", "isNewline", "", "char", "", "isPunctuation", "isQuote", "Levenshtein", "intellij.grazie"})
public final class Text {
    private static final Set<Byte> PUNCTUATIONS;
    public static final Text INSTANCE;

    public final boolean isNewline(char c) {
        return c == '\n';
    }

    public final boolean isPunctuation(char c) {
        byte by = (byte)Character.getType(c);
        return PUNCTUATIONS.contains(by);
    }

    public final boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    private Text() {
    }

    static {
        Text text2;
        INSTANCE = text2 = new Text();
        PUNCTUATIONS = SetsKt.setOf((Object[])new Byte[]{(byte)21, (byte)22, (byte)24, (byte)23, (byte)20, (byte)29, (byte)30});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/utils/Text$Levenshtein;", "", "()V", "levenshtein", "Lorg/apache/commons/text/similarity/LevenshteinDistance;", "distance", "", "str1", "", "str2", "intellij.grazie"})
    public static final class Levenshtein {
        private static final LevenshteinDistance levenshtein;
        public static final Levenshtein INSTANCE;

        public final int distance(@Nullable CharSequence str1, @Nullable CharSequence str2) {
            Integer n = levenshtein.apply(str1, str2);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"levenshtein.apply(str1, str2)");
            return n;
        }

        private Levenshtein() {
        }

        static {
            Levenshtein levenshtein;
            INSTANCE = levenshtein = new Levenshtein();
            Levenshtein.levenshtein = new LevenshteinDistance();
        }
    }
}

