/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.parse;

import java.util.List;
import java.util.Locale;
import org.gradle.internal.impldep.org.simpleframework.http.parse.ListParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageParser
extends ListParser<Locale> {
    public LanguageParser() {
    }

    public LanguageParser(String text) {
        super(text);
    }

    public LanguageParser(List<String> list) {
        super(list);
    }

    @Override
    protected Locale create(char[] text, int start, int len) {
        String language = this.language(text, start, len);
        String country = this.country(text, start, len);
        return new Locale(language, country);
    }

    private String language(char[] text, int start, int len) {
        int mark = start;
        int size = 0;
        while (start < len) {
            char next = text[start];
            if (this.terminal(next)) {
                return new String(text, mark, size);
            }
            ++size;
            ++start;
        }
        return new String(text, mark, len);
    }

    private String country(char[] text, int start, int len) {
        int size = len;
        while (start < len) {
            if (text[start++] == '-') {
                return new String(text, start, --size);
            }
            --size;
        }
        return "";
    }

    private boolean terminal(char ch) {
        return ch == ' ' || ch == '-' || ch == ';';
    }
}

