/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterSuiteEvent
extends AbstractTestEvent {
    public AfterSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            AfterSuiteEvent.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        if (testProxy != this.getResultsViewer().getTestsRootNode()) {
            if (testProxy instanceof GradleSMTestProxy) {
                TestEventResult lastResult = ((GradleSMTestProxy)testProxy).getLastResult();
                if (lastResult == TestEventResult.FAILURE) {
                    result = TestEventResult.FAILURE;
                }
                ((GradleSMTestProxy)testProxy).setLastResult(result);
            }
            switch (result) {
                case SUCCESS: {
                    testProxy.setFinished();
                    break;
                }
                case FAILURE: {
                    testProxy.setTestFailed("", null, false);
                    break;
                }
                case SKIPPED: {
                    testProxy.setTestIgnored(null, null);
                    break;
                }
            }
            this.getResultsViewer().onSuiteFinished(testProxy);
            this.getExecutionConsole().getEventPublisher().onSuiteFinished(testProxy);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AfterSuiteEvent", "process"));
    }
}

