/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocRenderManager {
    private static final Key<Boolean> DOC_RENDER_ENABLED = Key.create((String)"doc.render.enabled");

    public static void setDocRenderingEnabled(@NotNull Editor editor, @Nullable Boolean value2) {
        if (editor == null) {
            DocRenderManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean enabledBefore = DocRenderManager.isDocRenderingEnabled(editor);
        editor.putUserData(DOC_RENDER_ENABLED, (Object)value2);
        boolean enabledAfter = DocRenderManager.isDocRenderingEnabled(editor);
        if (enabledAfter != enabledBefore) {
            DocRenderManager.resetEditorToDefaultState(editor);
        }
    }

    public static boolean isDocRenderingEnabled(@NotNull Editor editor) {
        if (editor == null) {
            DocRenderManager.$$$reportNull$$$0(1);
        }
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return false;
        }
        Boolean value2 = (Boolean)editor.getUserData(DOC_RENDER_ENABLED);
        return value2 == null ? EditorSettingsExternalizable.getInstance().isDocCommentRenderingEnabled() : value2.booleanValue();
    }

    public static void resetAllEditorsToDefaultState() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            DocRenderItem.resetToDefaultState(editor);
            DocRenderPassFactory.forceRefreshOnNextPass(editor);
        }
        for (Editor editor : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)editor).restart();
        }
    }

    public static void resetEditorToDefaultState(@NotNull Editor editor) {
        if (editor == null) {
            DocRenderManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocRenderItem.resetToDefaultState(editor);
        DocRenderPassFactory.forceRefreshOnNextPass(editor);
        Project project = editor.getProject();
        if (project != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setDocRenderingEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocRenderingEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorToDefaultState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

