/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/ParameterHintsSettingsMigration;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lang.impl"})
public final class ParameterHintsSettingsMigration
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        EditorSettingsExternalizable editorSettingsExternalizable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EditorSettingsExternalizable editorSettingsExternalizable2 = editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettingsExternalizable2, (String)"editorSettingsExternalizable");
        if (!editorSettingsExternalizable2.isShowParameterNameHints()) {
            editorSettingsExternalizable.setShowParameterNameHints(true);
            for (Language language : HintUtilsKt.getBaseLanguagesWithProviders()) {
                ParameterNameHintsSettings.Companion.getInstance().setIsEnabledForLanguage(false, language);
            }
        }
    }

    public ParameterHintsSettingsMigration() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)extensionNotApplicableException), (String)"ExtensionNotApplicableException.INSTANCE");
            throw (Throwable)extensionNotApplicableException;
        }
    }
}

