/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.util.breadcrumbs.BreadcrumbsPlacement;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.InvisibleWrapper;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffContentPanel
extends JPanel {
    @Nullable
    private DiffBreadcrumbsPanel myBreadcrumbs;
    private final Wrapper myTitle;
    private final Wrapper myTopBreadcrumbs;
    private final JComponent myContent;
    private final Wrapper myBottomBreadcrumbs;

    DiffContentPanel(@NotNull JComponent content2) {
        if (content2 == null) {
            DiffContentPanel.$$$reportNull$$$0(0);
        }
        this.myTitle = new InvisibleWrapper();
        this.myTopBreadcrumbs = new InvisibleWrapper();
        this.myBottomBreadcrumbs = new InvisibleWrapper();
        this.myContent = content2;
        DiffContentPanel.initLayout(this, (JComponent)this.myTitle, (JComponent)this.myTopBreadcrumbs, this.myContent, (JComponent)this.myBottomBreadcrumbs);
    }

    public void setTitle(@Nullable JComponent titles) {
        this.myTitle.setContent(titles);
    }

    public void setBreadcrumbs(@Nullable DiffBreadcrumbsPanel breadcrumbs) {
        if (breadcrumbs != null) {
            this.myBreadcrumbs = breadcrumbs;
        }
    }

    public void updateBreadcrumbsPlacement(@NotNull BreadcrumbsPlacement placement) {
        if (placement == null) {
            DiffContentPanel.$$$reportNull$$$0(1);
        }
        if (this.myBreadcrumbs == null) {
            return;
        }
        this.myTopBreadcrumbs.setContent((JComponent)(placement == BreadcrumbsPlacement.TOP ? this.myBreadcrumbs : null));
        this.myBottomBreadcrumbs.setContent((JComponent)(placement == BreadcrumbsPlacement.BOTTOM ? this.myBreadcrumbs : null));
        this.myBreadcrumbs.setCrumbsShown(placement != BreadcrumbsPlacement.HIDDEN);
        this.validate();
        this.repaint();
    }

    private static void initLayout(@NotNull DiffContentPanel contentPanel2, @NotNull JComponent title, @NotNull JComponent topBreadcrumbs, @NotNull JComponent content2, @NotNull JComponent bottomBreadcrumbs) {
        if (contentPanel2 == null) {
            DiffContentPanel.$$$reportNull$$$0(2);
        }
        if (title == null) {
            DiffContentPanel.$$$reportNull$$$0(3);
        }
        if (topBreadcrumbs == null) {
            DiffContentPanel.$$$reportNull$$$0(4);
        }
        if (content2 == null) {
            DiffContentPanel.$$$reportNull$$$0(5);
        }
        if (bottomBreadcrumbs == null) {
            DiffContentPanel.$$$reportNull$$$0(6);
        }
        contentPanel2.removeAll();
        MigLayout mgr = new MigLayout(new LC().flowY().fill().hideMode(3).insets("0").gridGapY("0"));
        contentPanel2.setLayout((LayoutManager)mgr);
        contentPanel2.add((Component)title, new CC().growX().minWidth("0").gapY("0", String.valueOf(DiffUtil.TITLE_GAP)));
        contentPanel2.add((Component)topBreadcrumbs, new CC().growX().minWidth("0"));
        contentPanel2.add((Component)content2, new CC().grow().push());
        contentPanel2.add((Component)bottomBreadcrumbs, new CC().growX().minWidth("0"));
    }

    public static void syncTitleHeights(@NotNull List<DiffContentPanel> panels) {
        if (panels == null) {
            DiffContentPanel.$$$reportNull$$$0(7);
        }
        List titles = ContainerUtil.map(panels, it -> it.myTitle);
        List topBreadcrumbs = ContainerUtil.map(panels, it -> it.myTopBreadcrumbs);
        List<JComponent> syncTitles = DiffUtil.createSyncHeightComponents(titles);
        List<JComponent> syncTopBreadcrumbs = DiffUtil.createSyncHeightComponents(topBreadcrumbs);
        for (int i2 = 0; i2 < panels.size(); ++i2) {
            DiffContentPanel contentPanel2 = panels.get(i2);
            JComponent title = syncTitles.get(i2);
            JComponent topBreadcrumb = syncTopBreadcrumbs.get(i2);
            DiffContentPanel.initLayout(contentPanel2, title, topBreadcrumb, contentPanel2.myContent, (JComponent)contentPanel2.myBottomBreadcrumbs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topBreadcrumbs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomBreadcrumbs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/side/DiffContentPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBreadcrumbsPlacement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initLayout";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "syncTitleHeights";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

