/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunOnTargetComboBox;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BaseRCSettingsConfigurable;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunConfigurationStorageUi;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.ValidationResult;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentsConfigurable;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.ui.TargetAwareRunConfigurationEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SingleConfigurationConfigurable<Config extends RunConfiguration>
extends BaseRCSettingsConfigurable {
    public static final DataKey<String> RUN_ON_TARGET_NAME_KEY = DataKey.create((String)"RunOnTargetName");
    private static final Logger LOG = Logger.getInstance(SingleConfigurationConfigurable.class);
    private final PlainDocument myNameDocument;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Executor myExecutor;
    private ValidationResult myLastValidationResult;
    private boolean myValidationResultValid;
    private MyValidatableComponent myComponent;
    private final @NlsContexts.ConfigurableName String myDisplayName;
    private final String myHelpTopic;
    private final boolean myBrokenConfiguration;
    private boolean myIsAllowRunningInParallel;
    private String myDefaultTargetName;
    private String myFolderName;
    private boolean myChangingNameFromCode;

    private SingleConfigurationConfigurable(@NotNull RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(0);
        }
        super(ConfigurationSettingsEditorWrapper.createWrapper(settings), settings);
        this.myNameDocument = new PlainDocument();
        this.myLastValidationResult = null;
        this.myValidationResultValid = false;
        this.myIsAllowRunningInParallel = false;
        this.myProject = settings.getConfiguration().getProject();
        this.myExecutor = executor;
        Config configuration = this.getConfiguration();
        this.myDisplayName = ((RunnerAndConfigurationSettings)this.getSettings()).getName();
        this.myHelpTopic = configuration.getType().getHelpTopic();
        this.myBrokenConfiguration = !configuration.getType().isManaged();
        this.setFolderName(((RunnerAndConfigurationSettings)this.getSettings()).getFolderName());
        this.setNameText(configuration.getName());
        this.myNameDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                RunConfiguration runConfiguration;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SingleConfigurationConfigurable.this.setModified(true);
                if (!SingleConfigurationConfigurable.this.myChangingNameFromCode && (runConfiguration = ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getConfiguration()) instanceof LocatableConfigurationBase) {
                    ((LocatableConfigurationBase)runConfiguration).setNameChangedByUser(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/SingleConfigurationConfigurable$1", "textChanged"));
            }
        });
        this.getEditor().addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<RunnerAndConfigurationSettings>(){

            public void stateChanged(@NotNull SettingsEditor<RunnerAndConfigurationSettings> settingsEditor) {
                if (settingsEditor == null) {
                    2.$$$reportNull$$$0(0);
                }
                SingleConfigurationConfigurable.this.myValidationResultValid = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsEditor", "com/intellij/execution/impl/SingleConfigurationConfigurable$2", "stateChanged"));
            }
        });
    }

    @NotNull
    public static <Config extends RunConfiguration> SingleConfigurationConfigurable<Config> editSettings(@NotNull RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(1);
        }
        SingleConfigurationConfigurable<Config> configurable2 = new SingleConfigurationConfigurable<Config>(settings, executor);
        configurable2.reset();
        SingleConfigurationConfigurable<Config> singleConfigurationConfigurable = configurable2;
        if (singleConfigurationConfigurable == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(2);
        }
        return singleConfigurationConfigurable;
    }

    @Override
    boolean isSpecificallyModified() {
        return this.myComponent != null && this.myComponent.myRCStorageUi != null && this.myComponent.myRCStorageUi.isModified();
    }

    public void apply() throws ConfigurationException {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getSettings();
        RunConfiguration runConfiguration = settings.getConfiguration();
        settings.setName(this.getNameText());
        runConfiguration.setAllowRunningInParallel(this.myIsAllowRunningInParallel);
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            ((TargetEnvironmentAwareRunProfile)runConfiguration).setDefaultTargetName(this.myDefaultTargetName);
        }
        settings.setFolderName(this.myFolderName);
        if (this.myComponent.myRCStorageUi != null) {
            this.myComponent.myRCStorageUi.apply(settings);
        }
        super.apply();
        RunManagerImpl.getInstanceImpl(this.myProject).addConfiguration(settings);
    }

    public void reset() {
        RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)this.getSettings();
        this.setNameText(configuration.getName());
        super.reset();
        if (this.myComponent == null) {
            this.myComponent = new MyValidatableComponent();
        }
        this.myComponent.doReset();
    }

    void updateWarning() {
        this.myValidationResultValid = false;
        if (this.myComponent != null) {
            this.myComponent.updateWarning();
        }
    }

    @Override
    public final JComponent createComponent() {
        this.myComponent.myNameText.setEnabled(!this.myBrokenConfiguration);
        JComponent result2 = this.myComponent.getWholePanel();
        DataManager.registerDataProvider((JComponent)result2, dataId -> {
            RunOnTargetComboBox runOnComboBox;
            if (ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return this.getEditor();
            }
            if (RUN_ON_TARGET_NAME_KEY.is(dataId) && (runOnComboBox = (RunOnTargetComboBox)this.myComponent.myRunOnComboBox) != null) {
                return runOnComboBox.getSelectedTargetName();
            }
            return null;
        });
        Dimension size = result2.getPreferredSize();
        result2.setPreferredSize(new Dimension(Math.min(size.width, 800), Math.min(size.height, 600)));
        return result2;
    }

    final JComponent getValidationComponent() {
        return this.myComponent.myValidationPanel;
    }

    public boolean isStoredInFile() {
        return this.myComponent != null && this.myComponent.myRCStorageUi != null && this.myComponent.myRCStorageUi.isStoredInFile();
    }

    @Nullable
    private ValidationResult getValidationResult() {
        if (!this.myValidationResultValid) {
            this.myLastValidationResult = null;
            RunnerAndConfigurationSettings snapshot = null;
            try {
                snapshot = this.createSnapshot(false);
                snapshot.setName(this.getNameText());
                snapshot.checkSettings(this.myExecutor);
                for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                    ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)snapshot.getConfiguration());
                    if (runner == null) continue;
                    SingleConfigurationConfigurable.checkConfiguration(runner, snapshot);
                }
            }
            catch (ConfigurationException e) {
                this.myLastValidationResult = this.createValidationResult(snapshot, e);
            }
            this.myValidationResultValid = true;
        }
        return this.myLastValidationResult;
    }

    private ValidationResult createValidationResult(RunnerAndConfigurationSettings snapshot, ConfigurationException e) {
        if (!e.shouldShowInDumbMode() && DumbService.isDumb((Project)this.myProject)) {
            return null;
        }
        return new ValidationResult(e.getLocalizedMessage(), e instanceof RuntimeConfigurationException ? e.getTitle() : ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), this.getQuickFix(snapshot, e));
    }

    @Nullable
    private Runnable getQuickFix(RunnerAndConfigurationSettings snapshot, ConfigurationException exception) {
        Runnable quickFix = exception.getQuickFix();
        if (quickFix != null && snapshot != null) {
            return () -> {
                quickFix.run();
                this.getEditor().resetFrom((Object)snapshot);
            };
        }
        return quickFix;
    }

    private static void checkConfiguration(@NotNull ProgramRunner<?> runner, @NotNull RunnerAndConfigurationSettings snapshot) throws RuntimeConfigurationException {
        if (runner == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(3);
        }
        if (snapshot == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(4);
        }
        RunnerSettings runnerSettings2 = snapshot.getRunnerSettings(runner);
        ConfigurationPerRunnerSettings configurationSettings = snapshot.getConfigurationSettings(runner);
        try {
            runner.checkConfiguration(runnerSettings2, configurationSettings);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public final void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    public final String getNameText() {
        try {
            return this.myNameDocument.getText(0, this.myNameDocument.getLength());
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public final void addNameListener(DocumentListener listener2) {
        this.myNameDocument.addDocumentListener(listener2);
    }

    public final void addSharedListener(ActionListener listener2) {
        if (this.myComponent.myRCStorageUi != null) {
            this.myComponent.myRCStorageUi.addStoreAsFileCheckBoxListener(listener2);
        }
    }

    public final void setNameText(String name) {
        this.myChangingNameFromCode = true;
        try {
            try {
                if (!this.myNameDocument.getText(0, this.myNameDocument.getLength()).equals(name)) {
                    this.myNameDocument.replace(0, this.myNameDocument.getLength(), name, null);
                }
            }
            catch (BadLocationException e) {
                LOG.error((Throwable)e);
            }
        }
        finally {
            this.myChangingNameFromCode = false;
        }
    }

    public final boolean isValid() {
        return this.getValidationResult() == null;
    }

    public final JTextField getNameTextField() {
        return this.myComponent.myNameText;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    @NotNull
    public Config getConfiguration() {
        RunConfiguration runConfiguration = ((RunnerAndConfigurationSettings)this.getSettings()).getConfiguration();
        if (runConfiguration == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(5);
        }
        return (Config)runConfiguration;
    }

    @NotNull
    public RunnerAndConfigurationSettings createSnapshot(boolean cloneBeforeRunTasks) throws ConfigurationException {
        RunnerAndConfigurationSettings snapshot = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
        RunConfiguration runConfiguration = snapshot.getConfiguration();
        runConfiguration.setAllowRunningInParallel(this.myIsAllowRunningInParallel);
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            ((TargetEnvironmentAwareRunProfile)runConfiguration).setDefaultTargetName(this.myDefaultTargetName);
        }
        if (cloneBeforeRunTasks) {
            RunManagerImplKt.cloneBeforeRunTasks(runConfiguration);
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = snapshot;
        if (runnerAndConfigurationSettings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(6);
        }
        return runnerAndConfigurationSettings;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public void setFolderName(@Nullable String folderName) {
        if (!Objects.equals(this.myFolderName, folderName)) {
            this.myFolderName = folderName;
            this.setModified(true);
        }
    }

    @Nullable
    public String getFolderName() {
        return this.myFolderName;
    }

    private void setTargetName(String chosenTarget) {
        this.myDefaultTargetName = chosenTarget;
        SettingsEditor editor = this.getEditor();
        if (editor instanceof TargetAwareRunConfigurationEditor) {
            ((TargetAwareRunConfigurationEditor)editor).targetChanged(chosenTarget);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/SingleConfigurationConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/SingleConfigurationConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "editSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editSettings";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyValidatableComponent {
        private JLabel myNameLabel;
        private JTextField myNameText;
        private JComponent myWholePanel;
        private JPanel myComponentPlace;
        private JBLabel myWarningLabel;
        private JButton myFixButton;
        private JSeparator mySeparator;
        private JBCheckBox myIsAllowRunningInParallelCheckBox;
        private JPanel myRCStoragePanel;
        @Nullable
        private final RunConfigurationStorageUi myRCStorageUi;
        private JPanel myValidationPanel;
        private JBScrollPane myJBScrollPane;
        private ComboBox myRunOnComboBox;
        private JLabel myManageTargetsLabel;
        private JPanel myRunOnPanel;
        private JPanel myRunOnPanelInner;
        private Runnable myQuickFix = null;
        private boolean myWindowResizedOnce = false;

        MyValidatableComponent() {
            this.$$$setupUI$$$();
            this.myNameLabel.setLabelFor(this.myNameText);
            this.myNameText.setDocument(SingleConfigurationConfigurable.this.myNameDocument);
            SingleConfigurationConfigurable.this.getEditor().addSettingsEditorListener(settingsEditor -> this.updateWarning());
            this.myWarningLabel.setCopyable(true);
            this.myWarningLabel.setAllowAutoWrapping(true);
            this.myWarningLabel.setIcon(AllIcons.General.BalloonError);
            this.myComponentPlace.setLayout(new GridBagLayout());
            this.myComponentPlace.add((Component)this.getEditorComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            this.myComponentPlace.doLayout();
            this.myFixButton.setIcon(AllIcons.Actions.QuickfixBulb);
            this.updateWarning();
            this.myFixButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyValidatableComponent.this.myQuickFix == null) {
                        return;
                    }
                    MyValidatableComponent.this.myQuickFix.run();
                    SingleConfigurationConfigurable.this.myValidationResultValid = false;
                    MyValidatableComponent.this.updateWarning();
                }
            });
            this.myIsAllowRunningInParallelCheckBox.addActionListener(e -> {
                SingleConfigurationConfigurable.this.setModified(true);
                SingleConfigurationConfigurable.this.myIsAllowRunningInParallel = this.myIsAllowRunningInParallelCheckBox.isSelected();
            });
            RunConfigurationStorageUi runConfigurationStorageUi = this.myRCStorageUi = !SingleConfigurationConfigurable.this.myProject.isDefault() ? new RunConfigurationStorageUi(SingleConfigurationConfigurable.this.myProject, () -> SingleConfigurationConfigurable.this.setModified(true)) : null;
            if (this.myRCStorageUi != null) {
                this.myRCStorageUi.setShowCompatibilityHint(true);
                this.myRCStoragePanel.add(this.myRCStorageUi.createComponent());
            }
            this.myRunOnPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            UI.PanelFactory.panel((JComponent)this.myRunOnPanelInner).withLabel(ExecutionBundle.message((String)"run.on", (Object[])new Object[0])).withComment(ExecutionBundle.message((String)"edit.run.configuration.run.configuration.run.on.comment", (Object[])new Object[0])).addToPanel(this.myRunOnPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0), false);
            JLabel runOnLabel = (JLabel)UIUtil.findComponentOfType((JComponent)this.myRunOnPanel, JLabel.class);
            if (runOnLabel != null) {
                runOnLabel.setLabelFor((Component)this.myRunOnComboBox);
                Dimension nameSize = this.myNameLabel.getPreferredSize();
                Dimension runOnSize = runOnLabel.getPreferredSize();
                double width = Math.max(nameSize.getWidth(), runOnSize.getWidth());
                this.myNameLabel.setPreferredSize(new Dimension((int)width, (int)nameSize.getHeight()));
                runOnLabel.setPreferredSize(new Dimension((int)width, (int)runOnSize.getHeight()));
            }
            this.myRunOnComboBox.addActionListener(e -> {
                String chosenTarget = ((RunOnTargetComboBox)this.myRunOnComboBox).getSelectedTargetName();
                if (!StringUtil.equals((CharSequence)SingleConfigurationConfigurable.this.myDefaultTargetName, (CharSequence)chosenTarget)) {
                    SingleConfigurationConfigurable.this.setModified(true);
                    SingleConfigurationConfigurable.this.setTargetName(chosenTarget);
                    SingleConfigurationConfigurable.this.updateWarning();
                }
            });
        }

        private void doReset() {
            RunConfiguration configuration = ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getConfiguration();
            boolean isManagedRunConfiguration = configuration.getType().isManaged();
            if (this.myRCStorageUi != null) {
                this.myRCStorageUi.reset((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings());
            }
            boolean targetAware = configuration instanceof TargetEnvironmentAwareRunProfile && ((TargetEnvironmentAwareRunProfile)configuration).getDefaultLanguageRuntimeType() != null && Experiments.getInstance().isFeatureEnabled("run.targets");
            this.myRunOnPanel.setVisible(targetAware);
            if (targetAware) {
                String defaultTargetName = ((TargetEnvironmentAwareRunProfile)configuration).getDefaultTargetName();
                LanguageRuntimeType defaultRuntime = ((TargetEnvironmentAwareRunProfile)configuration).getDefaultLanguageRuntimeType();
                ((RunOnTargetComboBox)this.myRunOnComboBox).setDefaultLanguageRuntimeType(defaultRuntime);
                this.resetRunOnComboBox(defaultTargetName);
                SingleConfigurationConfigurable.this.setTargetName(defaultTargetName);
            }
            SingleConfigurationConfigurable.this.myIsAllowRunningInParallel = configuration.isAllowRunningInParallel();
            this.myIsAllowRunningInParallelCheckBox.setEnabled(isManagedRunConfiguration);
            this.myIsAllowRunningInParallelCheckBox.setSelected(SingleConfigurationConfigurable.this.myIsAllowRunningInParallel);
            this.myIsAllowRunningInParallelCheckBox.setVisible(SingleConfigurationConfigurable.this.getEditor() instanceof ConfigurationSettingsEditorWrapper && ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getFactory().getSingletonPolicy().isPolicyConfigurable());
        }

        private void resetRunOnComboBox(@Nullable String targetNameToChoose) {
            ((RunOnTargetComboBox)this.myRunOnComboBox).initModel();
            List configs = TargetEnvironmentsManager.getInstance((Project)SingleConfigurationConfigurable.this.myProject).getTargets().resolvedConfigs();
            ((RunOnTargetComboBox)this.myRunOnComboBox).addTargets(ContainerUtil.filter((Collection)configs, configuration -> TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)configuration).isSystemCompatible()));
            ((RunOnTargetComboBox)this.myRunOnComboBox).selectTarget(targetNameToChoose);
        }

        public final JComponent getWholePanel() {
            return this.myWholePanel;
        }

        public JComponent getEditorComponent() {
            return SingleConfigurationConfigurable.this.getEditor().getComponent();
        }

        @Nullable
        public ValidationResult getValidationResult() {
            return SingleConfigurationConfigurable.this.getValidationResult();
        }

        private void updateWarning() {
            ValidationResult configurationException = this.getValidationResult();
            if (configurationException != null) {
                this.mySeparator.setVisible(true);
                this.myWarningLabel.setVisible(true);
                this.myWarningLabel.setText(this.generateWarningLabelText(configurationException));
                Runnable quickFix = configurationException.getQuickFix();
                if (quickFix == null) {
                    this.myFixButton.setVisible(false);
                } else {
                    this.myFixButton.setVisible(true);
                    this.myQuickFix = quickFix;
                }
                this.myValidationPanel.setVisible(true);
                Window window = UIUtil.getWindow((Component)this.myWholePanel);
                if (!this.myWindowResizedOnce && window != null && window.isShowing()) {
                    Dimension size = window.getSize();
                    window.setSize(size.width, size.height + this.myValidationPanel.getPreferredSize().height);
                    this.myWindowResizedOnce = true;
                }
            } else {
                this.mySeparator.setVisible(false);
                this.myWarningLabel.setVisible(false);
                this.myFixButton.setVisible(false);
                this.myValidationPanel.setVisible(false);
            }
        }

        @NlsContexts.Label
        private String generateWarningLabelText(ValidationResult configurationException) {
            return new HtmlBuilder().append(configurationException.getTitle()).append(": ").wrapWith("b").wrapWith("body").addRaw(configurationException.getMessage()).wrapWith("html").toString();
        }

        private void createUIComponents() {
            this.myComponentPlace = new NonOpaquePanel();
            this.myRunOnComboBox = new RunOnTargetComboBox(SingleConfigurationConfigurable.this.myProject);
            this.myManageTargetsLabel = LinkLabel.create((String)ExecutionBundle.message((String)"edit.run.configuration.run.configuration.manage.targets.label", (Object[])new Object[0]), () -> {
                LanguageRuntimeType<?> languageRuntime;
                String selectedName = ((RunOnTargetComboBox)this.myRunOnComboBox).getSelectedTargetName();
                TargetEnvironmentsConfigurable configurable2 = new TargetEnvironmentsConfigurable(SingleConfigurationConfigurable.this.myProject, selectedName, languageRuntime = ((RunOnTargetComboBox)this.myRunOnComboBox).getDefaultLanguageRuntimeType());
                if (configurable2.openForEditing()) {
                    TargetEnvironmentConfiguration lastEdited = configurable2.getSelectedTargetConfig();
                    String chosenTargetName = lastEdited != null ? lastEdited.getDisplayName() : selectedName;
                    this.resetRunOnComboBox(chosenTargetName);
                    SingleConfigurationConfigurable.this.setTargetName(chosenTargetName);
                    SingleConfigurationConfigurable.this.updateWarning();
                }
            });
            this.myJBScrollPane = BaseRCSettingsConfigurable.wrapWithScrollPane(null);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JSeparator jSeparator;
            JButton jButton;
            JBLabel jBLabel;
            JPanel jPanel2;
            JPanel jPanel3;
            JPanel jPanel4;
            JPanel jPanel5;
            JBCheckBox jBCheckBox;
            JTextField jTextField;
            JLabel jLabel;
            this.createUIComponents();
            JPanel jPanel6 = new JPanel();
            this.myWholePanel = jPanel6;
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 5, 3, 0), -1, -1, false, false));
            jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myNameLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("edit.run.configuration.run.configuration.name.label"));
            jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNameText = jTextField = new JTextField();
            jTextField.setColumns(15);
            jPanel7.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myIsAllowRunningInParallelCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("run.configuration.allow.running.parallel"));
            jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel7.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(20, -1), null));
            this.myRCStoragePanel = jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout(1, 0, 5));
            jPanel7.add((Component)jPanel5, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
            JBScrollPane jBScrollPane = this.myJBScrollPane;
            jBScrollPane.setHorizontalScrollBarPolicy(31);
            jPanel6.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            JPanel jPanel8 = this.myComponentPlace;
            jBScrollPane.setViewportView(jPanel8);
            this.myRunOnPanel = jPanel4 = new JPanel();
            jPanel4.setLayout(new GridBagLayout());
            jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myRunOnPanelInner = jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel4.add((Component)jPanel3, gridBagConstraints);
            ComboBox comboBox2 = this.myRunOnComboBox;
            jPanel3.add((Component)comboBox2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(250, -1), null));
            JLabel jLabel2 = this.myManageTargetsLabel;
            this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("edit.run.configuration.run.configuration.manage.targets.label"));
            jPanel3.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(115, 16), null));
            Spacer spacer2 = new Spacer();
            jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myValidationPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel6.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myWarningLabel = jBLabel = new JBLabel();
            jBLabel.setText("####################");
            jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
            this.myFixButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("fix.run.configuration.problem.button"));
            jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.mySeparator = jSeparator = new JSeparator();
            jPanel2.add((Component)jSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

