/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElement2UsageTargetAdapter
implements PsiElementUsageTarget,
TypeSafeDataProvider,
PsiElementNavigationItem,
ItemPresentation,
ConfigurableUsageTarget {
    private final SmartPsiElementPointer<?> myPointer;
    @NotNull
    protected final FindUsagesOptions myOptions;
    private String myPresentableText;
    private Icon myIcon;

    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element2, @NotNull FindUsagesOptions options2) {
        if (element2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(1);
        }
        if (!(element2 instanceof NavigationItem)) {
            throw new IllegalArgumentException("Element is not a navigation item: " + element2);
        }
        this.myOptions = options2;
        PsiFile file2 = element2.getContainingFile();
        this.myPointer = file2 == null ? SmartPointerManager.getInstance((Project)element2.getProject()).createSmartPsiElementPointer(element2) : SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiElementPointer(element2, file2);
        this.update(element2, file2);
    }

    public PsiElement2UsageTargetAdapter(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(2);
        }
        this(element2, new FindUsagesOptions(element2.getProject()));
    }

    public String getName() {
        PsiElement element2 = this.getElement();
        return element2 instanceof NavigationItem ? ((NavigationItem)element2).getName() : null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        PsiElement2UsageTargetAdapter psiElement2UsageTargetAdapter = this;
        if (psiElement2UsageTargetAdapter == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(3);
        }
        return psiElement2UsageTargetAdapter;
    }

    public void navigate(boolean requestFocus) {
        PsiElement element2 = this.getElement();
        if (element2 instanceof Navigatable && ((Navigatable)element2).canNavigate()) {
            ((Navigatable)element2).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        PsiElement element2 = this.getElement();
        return element2 instanceof Navigatable && ((Navigatable)element2).canNavigate();
    }

    public boolean canNavigateToSource() {
        PsiElement element2 = this.getElement();
        return element2 instanceof Navigatable && ((Navigatable)element2).canNavigateToSource();
    }

    public PsiElement getTargetElement() {
        return this.getElement();
    }

    public String toString() {
        return this.getPresentableText();
    }

    public void findUsages() {
        PsiElement element2 = this.getElement();
        if (element2 != null) {
            ((FindManagerImpl)FindManager.getInstance((Project)element2.getProject())).getFindUsagesManager().startFindUsages(element2, this.myOptions);
        }
    }

    public PsiElement getElement() {
        return this.myPointer.getElement();
    }

    public void findUsagesInEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(4);
        }
        PsiElement element2 = this.getElement();
        FindManager.getInstance((Project)element2.getProject()).findUsagesInEditor(element2, editor);
    }

    public void highlightUsages(@NotNull PsiFile file2, @NotNull Editor editor, boolean clearHighlights) {
        if (file2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(6);
        }
        PsiElement target2 = this.getElement();
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        Project project = target2.getProject();
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(target2, true);
        PsiFile context = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file2);
        LocalSearchScope searchScope2 = new LocalSearchScope((PsiElement)context);
        Collection refs = handler2 == null ? ReferencesSearch.search((PsiElement)target2, (SearchScope)searchScope2, (boolean)false).findAll() : handler2.findReferencesToHighlight(target2, (SearchScope)searchScope2);
        new HighlightUsagesHandler.DoHighlightRunnable(new ArrayList(refs), project, target2, editor, context, clearHighlights).run();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    public boolean isReadOnly() {
        return this.isValid() && !this.getElement().isWritable();
    }

    public VirtualFile[] getFiles() {
        VirtualFile[] virtualFileArray;
        if (!this.isValid()) {
            return null;
        }
        PsiFile psiFile = this.getElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            virtualFileArray = null;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile;
        }
        return virtualFileArray;
    }

    public static PsiElement2UsageTargetAdapter @NotNull [] convert(PsiElement @NotNull [] psiElements) {
        if (psiElements == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(7);
        }
        PsiElement2UsageTargetAdapter[] targets2 = new PsiElement2UsageTargetAdapter[psiElements.length];
        for (int i2 = 0; i2 < targets2.length; ++i2) {
            targets2[i2] = new PsiElement2UsageTargetAdapter(psiElements[i2]);
        }
        if (targets2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(8);
        }
        return targets2;
    }

    static PsiElement @NotNull [] convertToPsiElements(PsiElement2UsageTargetAdapter @NotNull [] adapters) {
        if (adapters == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(9);
        }
        PsiElement[] targets2 = new PsiElement[adapters.length];
        for (int i2 = 0; i2 < targets2.length; ++i2) {
            targets2[i2] = adapters[i2].getElement();
        }
        if (targets2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(10);
        }
        return targets2;
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(11);
        }
        if (sink == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(12);
        }
        if (key == UsageView.USAGE_INFO_KEY) {
            PsiElement element2 = this.getElement();
            if (element2 != null && element2.getTextRange() != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo(element2));
            }
        } else if (key == UsageView.USAGE_SCOPE) {
            sink.put(UsageView.USAGE_SCOPE, (Object)this.myOptions.searchScope);
        }
    }

    public KeyboardShortcut getShortcut() {
        return UsageViewImpl.getShowUsagesWithSettingsShortcut();
    }

    @NotNull
    public String getLongDescriptiveName() {
        SearchScope searchScope2 = this.myOptions.searchScope;
        String scopeString = searchScope2.getDisplayName();
        PsiElement psiElement = this.getElement();
        String string = psiElement == null ? UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) : FindBundle.message("recent.find.usages.action.popup", StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)), DescriptiveNameUtil.getDescriptiveName((PsiElement)psiElement), scopeString);
        if (string == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void showSettings() {
        PsiElement element2 = this.getElement();
        if (element2 != null) {
            FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.myPointer.getProject())).getFindUsagesManager();
            findUsagesManager.findUsages(element2, null, null, true, null);
        }
    }

    public void update() {
        PsiElement element2 = this.getElement();
        if (element2 != null) {
            this.update(element2, element2.getContainingFile());
        }
    }

    private void update(@NotNull PsiElement element2, PsiFile file2) {
        if (element2 == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(14);
        }
        if (file2 == null ? element2.isValid() : file2.isValid()) {
            ItemPresentation presentation2 = ((NavigationItem)element2).getPresentation();
            this.myIcon = presentation2 == null ? null : presentation2.getIcon(true);
            String string = this.myPresentableText = presentation2 == null ? UsageViewUtil.createNodeText(element2) : presentation2.getPresentableText();
            if (this.myIcon == null) {
                PsiFile psiFile;
                VirtualFile virtualFile;
                if (element2 instanceof PsiMetaOwner) {
                    PsiMetaOwner psiMetaOwner = (PsiMetaOwner)element2;
                    PsiMetaData metaData = psiMetaOwner.getMetaData();
                    if (metaData instanceof PsiPresentableMetaData) {
                        PsiPresentableMetaData psiPresentableMetaData = (PsiPresentableMetaData)metaData;
                        if (this.myIcon == null) {
                            this.myIcon = psiPresentableMetaData.getIcon();
                        }
                    }
                } else if (element2 instanceof PsiFile && (virtualFile = (psiFile = (PsiFile)element2).getVirtualFile()) != null) {
                    this.myIcon = VirtualFilePresentation.getIcon((VirtualFile)virtualFile);
                }
            }
        }
    }

    public String getPresentableText() {
        return this.myPresentableText;
    }

    public String getLocationString() {
        return null;
    }

    public Icon getIcon(boolean open2) {
        return this.myIcon;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPointer.getProject();
        if (project == null) {
            PsiElement2UsageTargetAdapter.$$$reportNull$$$0(15);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/PsiElement2UsageTargetAdapter";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/PsiElement2UsageTargetAdapter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPsiElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongDescriptiveName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiElements";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

