/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.InitialInfoBuilderState;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.RangesAssert;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.engine.ExpandableIndent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InitialInfoBuilder {
    private static final Logger LOG = Logger.getInstance(InitialInfoBuilder.class);
    private static final RangesAssert ASSERT = new RangesAssert();
    private static final boolean INLINE_TABS_ENABLED = "true".equalsIgnoreCase(System.getProperty("inline.tabs.enabled"));
    private final Map<AbstractBlockWrapper, Block> myResult;
    private final MultiMap<ExpandableIndent, AbstractBlockWrapper> myBlocksToForceChildrenIndent;
    private final MultiMap<Alignment, Block> myBlocksToAlign;
    private final Set<Alignment> myAlignmentsInsideRangeToModify;
    private boolean myCollectAlignmentsInsideFormattingRange;
    private final FormattingDocumentModel myModel;
    private final FormatTextRanges myAffectedRanges;
    private final List<TextRange> myExtendedAffectedRanges;
    private final int myPositionOfInterest;
    private final FormattingProgressCallback myProgressCallback;
    private final CommonCodeStyleSettings.IndentOptions myOptions;
    private final Stack<InitialInfoBuilderState> myStates;
    @NotNull
    private WhiteSpace myCurrentWhiteSpace;
    private CompositeBlockWrapper myRootBlockWrapper;
    private LeafBlockWrapper myPreviousBlock;
    private LeafBlockWrapper myFirstTokenBlock;
    private LeafBlockWrapper myLastTokenBlock;
    private SpacingImpl myCurrentSpaceProperty;

    private InitialInfoBuilder(Block rootBlock, FormattingDocumentModel model2, @Nullable FormatTextRanges affectedRanges, CommonCodeStyleSettings.IndentOptions options2, int positionOfInterest, @NotNull FormattingProgressCallback progressCallback) {
        if (progressCallback == null) {
            InitialInfoBuilder.$$$reportNull$$$0(0);
        }
        this.myResult = new THashMap();
        this.myBlocksToForceChildrenIndent = MultiMap.createLinked();
        this.myBlocksToAlign = new MultiMap();
        this.myAlignmentsInsideRangeToModify = new HashSet<Alignment>();
        this.myStates = new Stack();
        this.myModel = model2;
        this.myAffectedRanges = affectedRanges;
        this.myExtendedAffectedRanges = affectedRanges != null ? affectedRanges.getExtendedRanges() : null;
        this.myProgressCallback = progressCallback;
        this.myCurrentWhiteSpace = new WhiteSpace(this.getStartOffset(rootBlock), true);
        this.myOptions = options2;
        this.myPositionOfInterest = positionOfInterest;
    }

    @NotNull
    static InitialInfoBuilder prepareToBuildBlocksSequentially(Block root, FormattingDocumentModel model2, FormatProcessor.FormatOptions formatOptions, CommonCodeStyleSettings.IndentOptions options2, @NotNull FormattingProgressCallback progressCallback) {
        if (progressCallback == null) {
            InitialInfoBuilder.$$$reportNull$$$0(1);
        }
        InitialInfoBuilder builder2 = new InitialInfoBuilder(root, model2, formatOptions.myAffectedRanges, options2, formatOptions.myInterestingOffset, progressCallback);
        builder2.setCollectAlignmentsInsideFormattingRange(formatOptions.isReformatWithContext());
        builder2.buildFrom(root, 0, null, null, null);
        InitialInfoBuilder initialInfoBuilder = builder2;
        if (initialInfoBuilder == null) {
            InitialInfoBuilder.$$$reportNull$$$0(2);
        }
        return initialInfoBuilder;
    }

    private int getStartOffset(@NotNull Block rootBlock) {
        if (rootBlock == null) {
            InitialInfoBuilder.$$$reportNull$$$0(3);
        }
        int minOffset = rootBlock.getTextRange().getStartOffset();
        if (this.myAffectedRanges != null) {
            for (FormatTextRange range2 : this.myAffectedRanges.getRanges()) {
                if (range2.getStartOffset() >= minOffset) continue;
                minOffset = range2.getStartOffset();
            }
        }
        return minOffset;
    }

    public FormattingDocumentModel getFormattingDocumentModel() {
        return this.myModel;
    }

    public int getEndOffset() {
        int maxOffset;
        int maxDocOffset = this.myModel.getTextLength();
        int n = maxOffset = this.myRootBlockWrapper != null ? this.myRootBlockWrapper.getEndOffset() : 0;
        if (this.myAffectedRanges != null) {
            for (FormatTextRange range2 : this.myAffectedRanges.getRanges()) {
                if (range2.getTextRange().getEndOffset() <= maxOffset) continue;
                maxOffset = range2.getTextRange().getEndOffset();
            }
        }
        return Math.min(maxOffset, maxDocOffset);
    }

    public boolean iteration() {
        if (this.myStates.isEmpty()) {
            return true;
        }
        InitialInfoBuilderState state = (InitialInfoBuilderState)this.myStates.peek();
        this.doIteration(state);
        return this.myStates.isEmpty();
    }

    private AbstractBlockWrapper buildFrom(Block rootBlock, int index, @Nullable CompositeBlockWrapper parent, @Nullable WrapImpl currentWrapParent, @Nullable Block parentBlock) {
        WrapImpl wrap2 = (WrapImpl)rootBlock.getWrap();
        if (wrap2 != null) {
            wrap2.registerParent(currentWrapParent);
            currentWrapParent = wrap2;
        }
        TextRange textRange = rootBlock.getTextRange();
        int blockStartOffset = textRange.getStartOffset();
        if (parent != null) {
            ASSERT.checkChildRange(new TextRange(parent.getStartOffset(), parent.getEndOffset()), textRange, this.myModel);
        }
        this.myCurrentWhiteSpace.changeEndOffset(blockStartOffset, this.myModel, this.myOptions);
        this.collectAlignments(rootBlock);
        if (this.isInsideFormattingRanges(textRange) || this.shouldCollectAlignmentsAround(textRange)) {
            List subBlocks = rootBlock.getSubBlocks();
            if (subBlocks.isEmpty()) {
                AbstractBlockWrapper wrapper2 = this.buildLeafBlock(rootBlock, parent, false, index, parentBlock);
                if (!subBlocks.isEmpty()) {
                    wrapper2.setIndent((IndentImpl)((Block)subBlocks.get(0)).getIndent());
                }
                return wrapper2;
            }
            return this.buildCompositeBlock(rootBlock, parent, index, currentWrapParent);
        }
        return this.buildLeafBlock(rootBlock, parent, true, index, parentBlock);
    }

    private boolean shouldCollectAlignmentsAround(TextRange range2) {
        return this.myCollectAlignmentsInsideFormattingRange && this.isInsideExtendedAffectedRange(range2);
    }

    private void collectAlignments(Block rootBlock) {
        if (this.myCollectAlignmentsInsideFormattingRange && rootBlock.getAlignment() != null && this.isAffectedByFormatting(rootBlock) && !this.isDisabled(rootBlock.getTextRange())) {
            this.myAlignmentsInsideRangeToModify.add(rootBlock.getAlignment());
        }
        if (rootBlock.getAlignment() != null) {
            this.myBlocksToAlign.putValue((Object)rootBlock.getAlignment(), (Object)rootBlock);
        }
    }

    private boolean isInsideExtendedAffectedRange(TextRange range2) {
        if (this.myExtendedAffectedRanges == null) {
            return false;
        }
        for (TextRange affectedRange : this.myExtendedAffectedRanges) {
            if (!affectedRange.intersects(range2)) continue;
            return true;
        }
        return false;
    }

    private CompositeBlockWrapper buildCompositeBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, int index, @Nullable WrapImpl currentWrapParent) {
        CompositeBlockWrapper wrappedRootBlock = new CompositeBlockWrapper(rootBlock, this.myCurrentWhiteSpace, parent);
        if (index == 0) {
            wrappedRootBlock.arrangeParentTextRange();
        }
        if (this.myRootBlockWrapper == null) {
            this.myRootBlockWrapper = wrappedRootBlock;
            this.myRootBlockWrapper.setIndent((IndentImpl)Indent.getNoneIndent());
        }
        if (this.myPositionOfInterest != -1) {
            this.myResult.put(wrappedRootBlock, rootBlock);
        }
        InitialInfoBuilderState state = new InitialInfoBuilderState(rootBlock, wrappedRootBlock, currentWrapParent);
        this.myStates.push((Object)state);
        return wrappedRootBlock;
    }

    private void doIteration(@NotNull InitialInfoBuilderState state) {
        if (state == null) {
            InitialInfoBuilder.$$$reportNull$$$0(4);
        }
        Block currentRoot = state.parentBlock;
        List subBlocks = currentRoot.getSubBlocks();
        int currentBlockIndex = state.getIndexOfChildBlockToProcess();
        Block currentBlock = (Block)subBlocks.get(currentBlockIndex);
        this.initCurrentWhiteSpace(currentRoot, state.previousBlock, currentBlock);
        AbstractBlockWrapper wrapper2 = this.buildFrom(currentBlock, currentBlockIndex, state.wrappedBlock, state.parentBlockWrap, currentRoot);
        this.registerExpandableIndents(currentBlock, wrapper2);
        if (wrapper2.getIndent() == null) {
            wrapper2.setIndent((IndentImpl)currentBlock.getIndent());
        }
        if (state.childBlockProcessed(currentBlock, wrapper2, this.myOptions)) {
            while (!this.myStates.isEmpty() && ((InitialInfoBuilderState)this.myStates.peek()).isProcessed()) {
                this.myStates.pop();
            }
        }
    }

    private void initCurrentWhiteSpace(@NotNull Block currentRoot, @Nullable Block previousBlock, @NotNull Block currentBlock) {
        if (currentRoot == null) {
            InitialInfoBuilder.$$$reportNull$$$0(5);
        }
        if (currentBlock == null) {
            InitialInfoBuilder.$$$reportNull$$$0(6);
        }
        if (previousBlock != null || this.myCurrentWhiteSpace.isIsFirstWhiteSpace()) {
            this.myCurrentSpaceProperty = (SpacingImpl)currentRoot.getSpacing(previousBlock, currentBlock);
        }
    }

    private void registerExpandableIndents(@NotNull Block block, @NotNull AbstractBlockWrapper wrapper2) {
        if (block == null) {
            InitialInfoBuilder.$$$reportNull$$$0(7);
        }
        if (wrapper2 == null) {
            InitialInfoBuilder.$$$reportNull$$$0(8);
        }
        if (block.getIndent() instanceof ExpandableIndent) {
            ExpandableIndent indent = (ExpandableIndent)block.getIndent();
            this.myBlocksToForceChildrenIndent.putValue((Object)indent, (Object)wrapper2);
        }
    }

    private AbstractBlockWrapper buildLeafBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, boolean readOnly, int index, @Nullable Block parentBlock) {
        LeafBlockWrapper result2 = this.doProcessSimpleBlock(rootBlock, parent, readOnly, index, parentBlock);
        this.myProgressCallback.afterWrappingBlock(result2);
        return result2;
    }

    private LeafBlockWrapper doProcessSimpleBlock(Block rootBlock, @Nullable CompositeBlockWrapper parent, boolean readOnly, int index, @Nullable Block parentBlock) {
        if (!INLINE_TABS_ENABLED && !this.myCurrentWhiteSpace.containsLineFeeds()) {
            this.myCurrentWhiteSpace.setForceSkipTabulationsUsage(true);
        }
        TextRange textRange = rootBlock.getTextRange();
        LeafBlockWrapper info = new LeafBlockWrapper(rootBlock, parent, this.myCurrentWhiteSpace, this.myModel, this.myOptions, this.myPreviousBlock, readOnly, textRange);
        if (index == 0) {
            info.arrangeParentTextRange();
        }
        if (this.myPreviousBlock != null) {
            this.myPreviousBlock.setNextBlock(info);
        }
        if (this.myFirstTokenBlock == null) {
            this.myFirstTokenBlock = info;
        }
        this.myLastTokenBlock = info;
        if (this.currentWhiteSpaceIsReadOnly()) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        if (this.myCurrentSpaceProperty != null) {
            this.myCurrentWhiteSpace.setIsSafe(this.myCurrentSpaceProperty.isSafe());
            this.myCurrentWhiteSpace.setKeepFirstColumn(this.myCurrentSpaceProperty.shouldKeepFirstColumn());
        }
        if (info.isEndOfCodeBlock()) {
            this.myCurrentWhiteSpace.setBeforeCodeBlockEnd(true);
        }
        info.setSpaceProperty(this.myCurrentSpaceProperty);
        this.myCurrentWhiteSpace = new WhiteSpace(textRange.getEndOffset(), false);
        if (this.isDisabled(this.myCurrentWhiteSpace.getTextRange())) {
            this.myCurrentWhiteSpace.setReadOnly(true);
        }
        this.myPreviousBlock = info;
        if (this.myPositionOfInterest != -1 && (textRange.contains(this.myPositionOfInterest) || textRange.getEndOffset() == this.myPositionOfInterest)) {
            this.myResult.put(info, rootBlock);
            if (parent != null) {
                this.myResult.put(parent, parentBlock);
            }
        }
        return info;
    }

    private boolean currentWhiteSpaceIsReadOnly() {
        if (this.myCurrentSpaceProperty != null && this.myCurrentSpaceProperty.isReadOnly()) {
            return true;
        }
        if (this.myAffectedRanges == null) {
            return false;
        }
        return this.myAffectedRanges.isWhitespaceReadOnly(this.myCurrentWhiteSpace.getTextRange());
    }

    private boolean isAffectedByFormatting(Block block) {
        if (this.myAffectedRanges == null) {
            return true;
        }
        List<FormatTextRange> allRanges = this.myAffectedRanges.getRanges();
        Document document = this.myModel.getDocument();
        int docLength = document.getTextLength();
        for (FormatTextRange range2 : allRanges) {
            int startOffset = range2.getStartOffset();
            if (startOffset >= docLength) continue;
            int lineNumber = document.getLineNumber(startOffset);
            int lineEndOffset = document.getLineEndOffset(lineNumber);
            int blockStartOffset = block.getTextRange().getStartOffset();
            if (blockStartOffset < startOffset || blockStartOffset >= lineEndOffset) continue;
            return true;
        }
        return false;
    }

    private boolean isDisabled(@NotNull TextRange range2) {
        if (range2 == null) {
            InitialInfoBuilder.$$$reportNull$$$0(9);
        }
        return this.myAffectedRanges != null && this.myAffectedRanges.isInDisabledRange(range2);
    }

    private boolean isInsideFormattingRanges(TextRange range2) {
        return this.myAffectedRanges == null || !this.myAffectedRanges.isReadOnly(range2);
    }

    public Map<AbstractBlockWrapper, Block> getBlockToInfoMap() {
        return this.myResult;
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myFirstTokenBlock;
    }

    public LeafBlockWrapper getLastTokenBlock() {
        return this.myLastTokenBlock;
    }

    public Set<Alignment> getAlignmentsInsideRangeToModify() {
        return this.myAlignmentsInsideRangeToModify;
    }

    public MultiMap<ExpandableIndent, AbstractBlockWrapper> getExpandableIndentsBlocks() {
        return this.myBlocksToForceChildrenIndent;
    }

    public MultiMap<Alignment, Block> getBlocksToAlign() {
        return this.myBlocksToAlign;
    }

    public void setCollectAlignmentsInsideFormattingRange(boolean value2) {
        this.myCollectAlignmentsInsideFormattingRange = value2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/InitialInfoBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBlock";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/InitialInfoBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareToBuildBlocksSequentially";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareToBuildBlocksSequentially";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doIteration";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initCurrentWhiteSpace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerExpandableIndents";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

