/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.cl;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.lang.UrlClassLoader;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PluginClassLoader
extends UrlClassLoader
implements PluginAwareClassLoader {
    private static final AtomicInteger instanceIdProducer;
    private ClassLoader[] parents;
    private final PluginDescriptor pluginDescriptor;
    private final List<String> libDirectories;
    private final AtomicLong edtTime;
    private final AtomicLong backgroundTime;
    private final AtomicInteger loadedClassCounter;
    private final ClassLoader coreLoader;
    private final PluginId pluginId;
    private final int instanceId;
    private volatile int state;
    private static final ActionWithPluginClassLoader<Class<?>, Void> loadClassInPluginCL;
    private static final ActionWithClassloader<Class<?>, Void> loadClassInCl;
    private static final Set<String> KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES;
    private static final ActionWithPluginClassLoader<URL, Void> findResourceInPluginCL;
    private static final ActionWithClassloader<URL, Void> findResourceInCl;
    private static final ActionWithPluginClassLoader<InputStream, Void> getResourceAsStreamInPluginCL;
    private static final ActionWithClassloader<InputStream, Void> getResourceAsStreamInCl;
    private static final ActionWithPluginClassLoader<Void, List<Enumeration<URL>>> findResourcesInPluginCL;
    private static final ActionWithClassloader<Void, List<Enumeration<URL>>> findResourcesInCl;

    public PluginClassLoader(@NotNull List<URL> urls, @NotNull @NotNull ClassLoader @NotNull [] parents2, @NotNull PluginDescriptor pluginDescriptor, @Nullable Path pluginRoot) {
        if (urls == null) {
            PluginClassLoader.$$$reportNull$$$0(0);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(2);
        }
        this(PluginClassLoader.build().urls(urls).allowLock().useCache(), parents2, pluginDescriptor, pluginRoot, null);
    }

    public PluginClassLoader(@NotNull UrlClassLoader.Builder builder2, @NotNull @NotNull ClassLoader @NotNull [] parents2, @NotNull PluginDescriptor pluginDescriptor, @Nullable Path pluginRoot, @Nullable ClassLoader coreLoader) {
        Path libDir;
        if (builder2 == null) {
            PluginClassLoader.$$$reportNull$$$0(3);
        }
        if (parents2 == null) {
            PluginClassLoader.$$$reportNull$$$0(4);
        }
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(5);
        }
        super(builder2);
        this.edtTime = new AtomicLong();
        this.backgroundTime = new AtomicLong();
        this.loadedClassCounter = new AtomicInteger();
        this.state = 1;
        this.instanceId = instanceIdProducer.incrementAndGet();
        this.parents = parents2;
        this.pluginDescriptor = pluginDescriptor;
        this.pluginId = pluginDescriptor.getPluginId();
        this.coreLoader = coreLoader;
        if (coreLoader != null && PluginClassLoader.class.desiredAssertionStatus()) {
            for (ClassLoader parent : this.parents) {
                if (parent != coreLoader) continue;
                Logger.getInstance(PluginClassLoader.class).error("Core loader must be not specified in parents (parents=" + Arrays.toString(parents2) + ", coreLoader=" + coreLoader + ")");
            }
        }
        this.libDirectories = new SmartList();
        if (pluginRoot != null && Files.exists(libDir = pluginRoot.resolve("lib"), new LinkOption[0])) {
            this.libDirectories.add(libDir.toAbsolutePath().toString());
        }
    }

    @ApiStatus.Internal
    public int getState() {
        return this.state;
    }

    @ApiStatus.Internal
    public void setState(int state) {
        this.state = state;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public long getEdtTime() {
        return this.edtTime.get();
    }

    public long getBackgroundTime() {
        return this.backgroundTime.get();
    }

    public long getLoadedClassCount() {
        return this.loadedClassCounter.get();
    }

    public Class<?> loadClass(@NotNull String name, boolean resolve2) throws ClassNotFoundException {
        Class<?> c;
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(6);
        }
        if ((c = this.tryLoadingClass(name, resolve2, null, true)) == null) {
            throw new ClassNotFoundException(name + " " + (Object)((Object)this));
        }
        return c;
    }

    @Nullable
    private <Result, ParameterType> Result processResourcesInParents(String name, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, ParameterType parameter) {
        return this.processResourcesInParents(name, actionWithPluginClassLoader, actionWithClassloader, null, parameter, true);
    }

    @Nullable
    private <Result, ParameterType> Result processResourcesInParents(String name, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, Set<ClassLoader> visited, ParameterType parameter, boolean withRoot) {
        for (ClassLoader parent : this.parents) {
            Result resource;
            if (parent == this.coreLoader) continue;
            if (visited == null) {
                visited = new HashSet<ClassLoader>();
                visited.add((ClassLoader)((Object)this));
            }
            if (!visited.add(parent) || !(parent instanceof PluginClassLoader ? (resource = actionWithPluginClassLoader.execute(name, (PluginClassLoader)((Object)parent), visited, actionWithPluginClassLoader, actionWithClassloader, parameter)) != null : (resource = actionWithClassloader.execute(name, parent, parameter)) != null)) continue;
            return resource;
        }
        if (withRoot && this.coreLoader != null && (visited == null || visited.add(this.coreLoader))) {
            return actionWithClassloader.execute(name, this.coreLoader, parameter);
        }
        return null;
    }

    @Nullable
    private Class<?> tryLoadingClass(@NotNull String name, boolean resolve2, @Nullable Set<ClassLoader> visited, boolean withRoot) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(7);
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        Class<?> c = null;
        if (!PluginClassLoader.mustBeLoadedByPlatform(name)) {
            c = this.loadClassInsideSelf(name);
        }
        if (c == null) {
            c = this.processResourcesInParents(name, loadClassInPluginCL, loadClassInCl, visited, null, withRoot);
        }
        if (c != null && resolve2) {
            this.resolveClass(c);
        }
        if (StartUpMeasurer.measuringPluginStartupCosts) {
            Application app = ApplicationManager.getApplication();
            boolean isEdt = app == null ? EventQueue.isDispatchThread() : app.isDispatchThread();
            (isEdt ? this.edtTime : this.backgroundTime).addAndGet(StartUpMeasurer.getCurrentTime() - startTime);
        }
        return c;
    }

    private static boolean mustBeLoadedByPlatform(@NonNls String className) {
        if (className.startsWith("java.")) {
            return true;
        }
        return className.startsWith("kotlin.") && (className.startsWith("kotlin.jvm.functions.") || className.startsWith("kotlin.reflect.") && className.indexOf(46, 15) < 0 || KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.contains(className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Class<?> loadClassInsideSelf(@NotNull String name) {
        if (name == null) {
            PluginClassLoader.$$$reportNull$$$0(8);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class c = this.findLoadedClass(name);
            if (c != null && c.getClassLoader() == this) {
                return c;
            }
            try {
                c = this._findClass(name);
            }
            catch (LinkageError e) {
                throw new PluginException("While loading class " + name + ": " + e.getMessage(), (Throwable)e, this.getPluginId());
            }
            if (c != null) {
                this.loadedClassCounter.incrementAndGet();
            }
            return c;
        }
    }

    public URL findResource(String name) {
        URL resource = this.findOwnResource(name);
        if (resource != null) {
            return resource;
        }
        return this.processResourcesInParents(name, findResourceInPluginCL, findResourceInCl, null);
    }

    @Nullable
    private URL findOwnResource(String name) {
        return super.findResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = this.getOwnResourceAsStream(name);
        if (stream != null) {
            return stream;
        }
        return this.processResourcesInParents(name, getResourceAsStreamInPluginCL, getResourceAsStreamInCl, null);
    }

    @Nullable
    private InputStream getOwnResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(this.findOwnResources(name));
        this.processResourcesInParents(name, findResourcesInPluginCL, findResourcesInCl, resources);
        return new DeepEnumeration(resources);
    }

    private Enumeration<URL> findOwnResources(String name) throws IOException {
        return super.findResources(name);
    }

    public void addLibDirectories(@NotNull Collection<String> libDirectories) {
        if (libDirectories == null) {
            PluginClassLoader.$$$reportNull$$$0(9);
        }
        this.libDirectories.addAll(libDirectories);
    }

    protected String findLibrary(String libName) {
        if (!this.libDirectories.isEmpty()) {
            String libFileName = System.mapLibraryName(libName);
            ListIterator<String> i2 = this.libDirectories.listIterator(this.libDirectories.size());
            while (i2.hasPrevious()) {
                File libFile = new File(i2.previous(), libFileName);
                if (!libFile.exists()) continue;
                return libFile.getAbsolutePath();
            }
        }
        return null;
    }

    @NotNull
    public PluginId getPluginId() {
        PluginId pluginId = this.pluginId;
        if (pluginId == null) {
            PluginClassLoader.$$$reportNull$$$0(10);
        }
        return pluginId;
    }

    @NotNull
    public PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            PluginClassLoader.$$$reportNull$$$0(11);
        }
        return pluginDescriptor;
    }

    public String toString() {
        return "PluginClassLoader[" + this.pluginDescriptor + "] " + super.toString();
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public List<ClassLoader> _getParents() {
        List<ClassLoader> list2 = Collections.unmodifiableList(Arrays.asList(this.parents));
        if (list2 == null) {
            PluginClassLoader.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @ApiStatus.Internal
    public void attachParent(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(13);
        }
        this.parents = (ClassLoader[])ArrayUtil.append((Object[])this.parents, (Object)classLoader);
    }

    @ApiStatus.Internal
    public boolean detachParent(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            PluginClassLoader.$$$reportNull$$$0(14);
        }
        int oldSize = this.parents.length;
        this.parents = (ClassLoader[])ArrayUtil.remove((Object[])this.parents, (Object)classLoader);
        return this.parents.length == oldSize - 1;
    }

    protected ProtectionDomain getProtectionDomain(URL url) {
        return new ProtectionDomain(new CodeSource(url, (Certificate[])null), null);
    }

    static {
        if (PluginClassLoader.registerAsParallelCapable()) {
            PluginClassLoader.markParallelCapable(PluginClassLoader.class);
        }
        instanceIdProducer = new AtomicInteger();
        loadClassInPluginCL = new ActionWithPluginClassLoader<Class<?>, Void>(){

            @Override
            Class<?> execute(String name, PluginClassLoader classloader, Set<ClassLoader> visited, ActionWithPluginClassLoader<Class<?>, Void> actionWithPluginClassLoader, ActionWithClassloader<Class<?>, Void> actionWithClassloader, Void parameter) {
                return classloader.tryLoadingClass(name, false, visited, false);
            }

            @Override
            protected Class<?> doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return null;
            }
        };
        loadClassInCl = new ActionWithClassloader<Class<?>, Void>(){

            @Override
            public Class<?> execute(String name, ClassLoader classloader, Void parameter) {
                try {
                    return classloader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        };
        KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES = new HashSet<String>(Arrays.asList("kotlin.Function", "kotlin.sequences.Sequence", "kotlin.ranges.IntRange", "kotlin.ranges.IntRange$Companion", "kotlin.ranges.IntProgression", "kotlin.ranges.ClosedRange", "kotlin.ranges.IntProgressionIterator", "kotlin.ranges.IntProgression$Companion", "kotlin.ranges.IntProgression", "kotlin.collections.IntIterator", "kotlin.Lazy", "kotlin.Unit", "kotlin.Pair", "kotlin.Triple", "kotlin.jvm.internal.DefaultConstructorMarker", "kotlin.jvm.internal.ClassBasedDeclarationContainer", "kotlin.properties.ReadWriteProperty", "kotlin.properties.ReadOnlyProperty", "kotlin.coroutines.ContinuationInterceptor", "kotlinx.coroutines.CoroutineDispatcher", "kotlin.coroutines.Continuation", "kotlin.coroutines.CoroutineContext", "kotlin.coroutines.CoroutineContext$Element", "kotlin.coroutines.CoroutineContext$Key"));
        String classes = System.getProperty("idea.kotlin.classes.used.in.signatures");
        if (classes != null) {
            StringTokenizer t = new StringTokenizer(classes, ",");
            while (t.hasMoreTokens()) {
                KOTLIN_STDLIB_CLASSES_USED_IN_SIGNATURES.add(t.nextToken());
            }
        }
        findResourceInPluginCL = new ActionWithPluginClassLoader<URL, Void>(){

            @Override
            protected URL doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return classloader.findOwnResource(name);
            }
        };
        findResourceInCl = new ActionWithClassloader<URL, Void>(){

            @Override
            public URL execute(String name, ClassLoader classloader, Void parameter) {
                return classloader.getResource(name);
            }
        };
        getResourceAsStreamInPluginCL = new ActionWithPluginClassLoader<InputStream, Void>(){

            @Override
            protected InputStream doExecute(String name, PluginClassLoader classloader, Void parameter) {
                return classloader.getOwnResourceAsStream(name);
            }
        };
        getResourceAsStreamInCl = new ActionWithClassloader<InputStream, Void>(){

            @Override
            public InputStream execute(String name, ClassLoader classloader, Void parameter) {
                return classloader.getResourceAsStream(name);
            }
        };
        findResourcesInPluginCL = new ActionWithPluginClassLoader<Void, List<Enumeration<URL>>>(){

            @Override
            protected Void doExecute(String name, PluginClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.findOwnResources(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        findResourcesInCl = new ActionWithClassloader<Void, List<Enumeration<URL>>>(){

            @Override
            public Void execute(String name, ClassLoader classloader, List<Enumeration<URL>> enumerations) {
                try {
                    enumerations.add(classloader.getResources(name));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libDirectories";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/cl/PluginClassLoader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "_getParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadingClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadClassInsideSelf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibDirectories";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "attachParent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "detachParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeepEnumeration
    implements Enumeration<URL> {
        private final List<Enumeration<URL>> list;
        private int myIndex;

        DeepEnumeration(@NotNull List<Enumeration<URL>> enumerations) {
            if (enumerations == null) {
                DeepEnumeration.$$$reportNull$$$0(0);
            }
            this.list = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.myIndex < this.list.size()) {
                Enumeration<URL> e = this.list.get(this.myIndex);
                if (e != null && e.hasMoreElements()) {
                    return true;
                }
                ++this.myIndex;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.myIndex).nextElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumerations", "com/intellij/ide/plugins/cl/PluginClassLoader$DeepEnumeration", "<init>"));
        }
    }

    private static abstract class ActionWithPluginClassLoader<Result, ParameterType> {
        private ActionWithPluginClassLoader() {
        }

        Result execute(String name, PluginClassLoader classloader, Set<ClassLoader> visited, ActionWithPluginClassLoader<Result, ParameterType> actionWithPluginClassLoader, ActionWithClassloader<Result, ParameterType> actionWithClassloader, ParameterType parameter) {
            Result resource = this.doExecute(name, classloader, parameter);
            if (resource != null) {
                return resource;
            }
            return (Result)classloader.processResourcesInParents(name, actionWithPluginClassLoader, actionWithClassloader, visited, parameter, false);
        }

        protected abstract Result doExecute(String var1, PluginClassLoader var2, ParameterType var3);
    }

    private static interface ActionWithClassloader<Result, ParameterType> {
        public Result execute(String var1, ClassLoader var2, ParameterType var3);
    }
}

